/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.adminui.gui;

import com.buuz135.adminui.gui.AdminIndexGui;
import com.buuz135.adminui.gui.NavBarHelper;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.common.util.FormatUtil;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class StatsGui
extends InteractiveCustomUIPage<SearchGuiData> {
    private Thread updateThread;

    public StatsGui(@Nonnull PlayerRef playerRef) {
        super(playerRef, CustomPageLifetime.CanDismissOrCloseThroughInteraction, SearchGuiData.CODEC);
    }

    public void build(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder uiCommandBuilder, @Nonnull UIEventBuilder uiEventBuilder, @Nonnull Store<EntityStore> store) {
        uiCommandBuilder.append("Pages/Stat/Buuz135_AdminUI_StatPage.ui");
        NavBarHelper.setupBar(ref, uiCommandBuilder, uiEventBuilder, store);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#BackButton", EventData.of((String)"Button", (String)"BackButton"), false);
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        this.buildList(ref, uiCommandBuilder, uiEventBuilder, (ComponentAccessor<EntityStore>)store, player);
        this.updateThread = new Thread(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                UICommandBuilder commandBuilder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.buildList(ref, commandBuilder, eventBuilder, (ComponentAccessor<EntityStore>)store, player);
                this.sendUpdate(commandBuilder, eventBuilder, false);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.updateThread.start();
    }

    public void handleDataEvent(@Nonnull Ref<EntityStore> ref, @Nonnull Store<EntityStore> store, @Nonnull SearchGuiData data) {
        super.handleDataEvent(ref, store, (Object)data);
        PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (NavBarHelper.handleData(ref, store, data.navbar, () -> this.updateThread.interrupt())) {
            this.updateThread.interrupt();
            return;
        }
        if (data.button != null && data.button.equals("BackButton")) {
            this.updateThread.interrupt();
            player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new AdminIndexGui(playerRef, CustomPageLifetime.CanDismiss));
            return;
        }
    }

    private void buildList(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder commandBuilder, @Nonnull UIEventBuilder eventBuilder, @Nonnull ComponentAccessor<EntityStore> componentAccessor, Player player) {
        double loadAverage;
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sunOSBean = (OperatingSystemMXBean)operatingSystemMXBean;
            double systemCpuLoad = sunOSBean.getSystemCpuLoad();
            double processCpuLoad = sunOSBean.getProcessCpuLoad();
            if (!(player.getPageManager().getCustomPage() instanceof StatsGui)) {
                return;
            }
            commandBuilder.set("#SystemCPUUsage.Text", (int)(systemCpuLoad * 100.0) + "%");
            commandBuilder.set("#SystemCPUUsageBar.Value", systemCpuLoad);
            commandBuilder.set("#ProcessCPUUsage.Text", (int)(processCpuLoad * 100.0) + "%");
            commandBuilder.set("#ProcessCPUUsageBar.Value", processCpuLoad);
            long used = sunOSBean.getTotalMemorySize() - sunOSBean.getFreeMemorySize();
            commandBuilder.set("#AllRamUsageBar.Value", (double)used / (double)sunOSBean.getTotalMemorySize());
            commandBuilder.set("#AllRamUsage.Text", FormatUtil.bytesToString((long)used));
            commandBuilder.set("#MaxAllRamUsage.Text", FormatUtil.bytesToString((long)sunOSBean.getTotalMemorySize()));
        }
        commandBuilder.set("#LoadAverageCPUUsage.Text", (String)((loadAverage = operatingSystemMXBean.getSystemLoadAverage()) < 0.0 ? "Unknown" : (int)(loadAverage * 100.0) + "%"));
        commandBuilder.set("#LoadAverageCPUUsageBar.Value", loadAverage);
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        commandBuilder.set("#ProcessUptime.Text", FormatUtil.timeUnitToString((long)runtimeMXBean.getUptime(), (TimeUnit)TimeUnit.MILLISECONDS));
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        commandBuilder.set("#ServerRamUsageBar.Value", (double)memoryUsage.getUsed() / (double)memoryUsage.getMax());
        commandBuilder.set("#ServerRamUsage.Text", FormatUtil.bytesToString((long)memoryUsage.getUsed()));
        commandBuilder.set("#MaxServerRamUsage.Text", FormatUtil.bytesToString((long)memoryUsage.getMax()));
    }

    protected void close() {
        super.close();
        this.updateThread.interrupt();
    }

    public void onDismiss(@NonNullDecl Ref<EntityStore> ref, @NonNullDecl Store<EntityStore> store) {
        super.onDismiss(ref, store);
        this.updateThread.interrupt();
    }

    public static class SearchGuiData {
        static final String KEY_BUTTON = "Button";
        static final String KEY_NAVBAR = "NavBar";
        public static final BuilderCodec<SearchGuiData> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(SearchGuiData.class, SearchGuiData::new).addField(new KeyedCodec("Button", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.button = s;
        }, searchGuiData -> searchGuiData.button)).addField(new KeyedCodec("NavBar", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.navbar = s;
        }, searchGuiData -> searchGuiData.navbar)).build();
        private String button;
        private String navbar;
    }
}

