/*
 * Decompiled with CFR 0.152.
 */
package org.toskan4134.NaturalRegeneration;

import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.tick.EntityTickingSystem;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatMap;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatValue;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatsModule;
import com.hypixel.hytale.server.core.modules.entitystats.asset.DefaultEntityStatTypes;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.Config;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.toskan4134.NaturalRegeneration.DamageTracker;
import org.toskan4134.NaturalRegeneration.RegenConfig;

public class RegenerationTickSystem
extends EntityTickingSystem<EntityStore> {
    private static final HytaleLogger LOGGER = HytaleLogger.forEnclosingClass();
    private final Config<RegenConfig> config;
    private int cachedHealthIndex = Integer.MIN_VALUE;
    private final Map<Integer, Float> timeAccumulators = new ConcurrentHashMap<Integer, Float>();

    public RegenerationTickSystem(Config<RegenConfig> config) {
        this.config = config;
    }

    @Nonnull
    public Query<EntityStore> getQuery() {
        return Query.and((Query[])new Query[]{Player.getComponentType(), EntityStatMap.getComponentType()});
    }

    public boolean isParallel(int archetypeChunkSize, int taskCount) {
        return false;
    }

    public void tick(float dt, int entityIndex, @Nonnull ArchetypeChunk<EntityStore> chunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
        float maxHealth;
        EntityStatMap statMap;
        float intervalSec;
        RegenConfig cfg = (RegenConfig)this.config.get();
        if (!cfg.isEnabled()) {
            return;
        }
        float accumulated = this.timeAccumulators.getOrDefault(entityIndex, Float.valueOf(0.0f)).floatValue() + dt;
        if (accumulated < (intervalSec = cfg.getIntervalSeconds())) {
            this.timeAccumulators.put(entityIndex, Float.valueOf(accumulated));
            return;
        }
        this.timeAccumulators.put(entityIndex, Float.valueOf(accumulated - intervalSec));
        if (this.cachedHealthIndex == Integer.MIN_VALUE) {
            this.cachedHealthIndex = DefaultEntityStatTypes.getHealth();
            if (this.cachedHealthIndex == Integer.MIN_VALUE) {
                return;
            }
        }
        if ((statMap = (EntityStatMap)chunk.getComponent(entityIndex, EntityStatsModule.get().getEntityStatMapComponentType())) == null) {
            return;
        }
        EntityStatValue healthValue = statMap.get(this.cachedHealthIndex);
        if (healthValue == null) {
            return;
        }
        float currentHealth = healthValue.get();
        if (currentHealth >= (maxHealth = healthValue.getMax())) {
            return;
        }
        if (!DamageTracker.canRegenerate(entityIndex, System.currentTimeMillis(), cfg.getDelayMs())) {
            return;
        }
        float regenAmount = cfg.getAmountHP();
        statMap.addStatValue(this.cachedHealthIndex, regenAmount);
        ((HytaleLogger.Api)LOGGER.atFine()).log("Regenerating " + regenAmount + " HP to player " + entityIndex + " (" + healthValue.get() + "/" + maxHealth + ")");
    }
}

