/*
 * Decompiled with CFR 0.152.
 */
package org.toskan4134.NaturalRegeneration;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;

public class RegenConfig {
    public static final BuilderCodec<RegenConfig> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(RegenConfig.class, RegenConfig::new).append(new KeyedCodec("Enabled", (Codec)Codec.BOOLEAN), (config, value, info) -> {
        config.enabled = value;
    }, (config, info) -> config.enabled).add()).append(new KeyedCodec("DelaySeconds", (Codec)Codec.FLOAT), (config, value, info) -> {
        config.delaySeconds = value.floatValue();
    }, (config, info) -> Float.valueOf(config.delaySeconds)).add()).append(new KeyedCodec("AmountHP", (Codec)Codec.FLOAT), (config, value, info) -> {
        config.amountHP = value.floatValue();
    }, (config, info) -> Float.valueOf(config.amountHP)).add()).append(new KeyedCodec("IntervalSeconds", (Codec)Codec.FLOAT), (config, value, info) -> {
        config.intervalSeconds = value.floatValue();
    }, (config, info) -> Float.valueOf(config.intervalSeconds)).add()).build();
    private boolean enabled = true;
    private float delaySeconds = 10.0f;
    private float amountHP = 1.0f;
    private float intervalSeconds = 1.0f;

    public boolean isEnabled() {
        return this.enabled;
    }

    public float getDelaySeconds() {
        return this.delaySeconds;
    }

    public long getDelayMs() {
        return (long)(this.delaySeconds * 1000.0f);
    }

    public float getAmountHP() {
        return this.amountHP;
    }

    public float getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public long getIntervalMs() {
        return (long)(this.intervalSeconds * 1000.0f);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDelaySeconds(float delaySeconds) {
        this.delaySeconds = Math.max(0.0f, delaySeconds);
    }

    public void setAmountHP(float amountHP) {
        this.amountHP = Math.max(0.1f, amountHP);
    }

    public void setIntervalSeconds(float intervalSeconds) {
        this.intervalSeconds = Math.max(0.1f, intervalSeconds);
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }
}

