/*
 * Decompiled with CFR 0.152.
 */
package org.toskan4134.NaturalRegeneration;

import com.hypixel.hytale.component.system.ISystem;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.util.Config;
import javax.annotation.Nonnull;
import org.toskan4134.NaturalRegeneration.DamageListenerSystem;
import org.toskan4134.NaturalRegeneration.DamageTracker;
import org.toskan4134.NaturalRegeneration.NaturalRegenerationCommand;
import org.toskan4134.NaturalRegeneration.RegenConfig;
import org.toskan4134.NaturalRegeneration.RegenerationTickSystem;

public class NaturalRegenerationPlugin
extends JavaPlugin {
    private final Config<RegenConfig> config = this.withConfig("NaturalRegeneration", RegenConfig.CODEC);

    public NaturalRegenerationPlugin(@Nonnull JavaPluginInit init) {
        super(init);
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("Starting " + this.getName() + " v" + this.getManifest().getVersion().toString());
    }

    protected void setup() {
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("Setting up plugin " + this.getName());
        this.config.save();
        this.getEntityStoreRegistry().registerSystem((ISystem)new DamageListenerSystem());
        this.getEntityStoreRegistry().registerSystem((ISystem)new RegenerationTickSystem(this.config));
        this.getCommandRegistry().registerCommand((AbstractCommand)new NaturalRegenerationCommand(this.config));
        ((HytaleLogger.Api)this.getLogger().atInfo()).log(this.getName() + " setup complete!");
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("Use /naturalregeneration to view and modify configuration");
    }

    protected void shutdown() {
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("Shutting down " + this.getName());
        DamageTracker.clearAll();
        ((HytaleLogger.Api)this.getLogger().atInfo()).log(this.getName() + " shutdown complete!");
    }
}

