/*
 * Decompiled with CFR 0.152.
 */
package org.toskan4134.NaturalRegeneration;

import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractCommandCollection;
import com.hypixel.hytale.server.core.command.system.basecommands.CommandBase;
import com.hypixel.hytale.server.core.util.Config;
import javax.annotation.Nonnull;
import org.toskan4134.NaturalRegeneration.RegenConfig;

public class NaturalRegenerationCommand
extends AbstractCommandCollection {
    public NaturalRegenerationCommand(Config<RegenConfig> config) {
        super("naturalregeneration", "Configure the Natural Regeneration plugin");
        this.setPermissionGroup(GameMode.Adventure);
        this.addAliases(new String[]{"naturalregen", "nr"});
        this.addSubCommand((AbstractCommand)new StatusCommand(config));
        this.addSubCommand((AbstractCommand)new ToggleCommand(config));
        this.addSubCommand((AbstractCommand)new DelayCommand(config));
        this.addSubCommand((AbstractCommand)new AmountCommand(config));
        this.addSubCommand((AbstractCommand)new IntervalCommand(config));
    }

    private static class StatusCommand
    extends CommandBase {
        private final Config<RegenConfig> config;

        public StatusCommand(Config<RegenConfig> config) {
            super("status", "Show current configuration");
            this.config = config;
        }

        protected void executeSync(@Nonnull CommandContext ctx) {
            RegenConfig cfg = (RegenConfig)this.config.get();
            StringBuilder msg = new StringBuilder();
            msg.append("=== Natural Regeneration ===\n\n");
            msg.append("Status: ").append(cfg.isEnabled() ? "ENABLED" : "DISABLED").append("\n");
            msg.append("Delay: ").append(cfg.getDelaySeconds()).append(" sec\n");
            msg.append("Amount: ").append(cfg.getAmountHP()).append(" HP\n");
            msg.append("Interval: ").append(cfg.getIntervalSeconds()).append(" sec");
            ctx.sendMessage(Message.raw((String)msg.toString()));
        }
    }

    private static class ToggleCommand
    extends CommandBase {
        private final Config<RegenConfig> config;

        public ToggleCommand(Config<RegenConfig> config) {
            super("toggle", "Toggle regeneration on/off");
            this.config = config;
        }

        protected void executeSync(@Nonnull CommandContext ctx) {
            RegenConfig cfg = (RegenConfig)this.config.get();
            cfg.toggle();
            this.config.save();
            ctx.sendMessage(Message.raw((String)("Regeneration: " + (cfg.isEnabled() ? "ENABLED" : "DISABLED"))));
        }
    }

    private static class DelayCommand
    extends CommandBase {
        private final Config<RegenConfig> config;
        private final RequiredArg<Float> secondsArg;

        public DelayCommand(Config<RegenConfig> config) {
            super("delay", "Set delay before regeneration starts");
            this.config = config;
            this.secondsArg = this.withRequiredArg("seconds", "Delay in seconds", (ArgumentType)ArgTypes.FLOAT);
        }

        protected void executeSync(@Nonnull CommandContext ctx) {
            Float seconds = (Float)ctx.get(this.secondsArg);
            if (seconds != null) {
                ((RegenConfig)this.config.get()).setDelaySeconds(seconds.floatValue());
                this.config.save();
                ctx.sendMessage(Message.raw((String)("Delay set to " + seconds + " seconds")));
            }
        }
    }

    private static class AmountCommand
    extends CommandBase {
        private final Config<RegenConfig> config;
        private final RequiredArg<Float> hpArg;

        public AmountCommand(Config<RegenConfig> config) {
            super("amount", "Set HP regenerated per tick");
            this.config = config;
            this.hpArg = this.withRequiredArg("hp", "HP amount", (ArgumentType)ArgTypes.FLOAT);
        }

        protected void executeSync(@Nonnull CommandContext ctx) {
            Float hp = (Float)ctx.get(this.hpArg);
            if (hp != null) {
                ((RegenConfig)this.config.get()).setAmountHP(hp.floatValue());
                this.config.save();
                ctx.sendMessage(Message.raw((String)("Amount set to " + hp + " HP per tick")));
            }
        }
    }

    private static class IntervalCommand
    extends CommandBase {
        private final Config<RegenConfig> config;
        private final RequiredArg<Float> secondsArg;

        public IntervalCommand(Config<RegenConfig> config) {
            super("interval", "Set interval between regeneration ticks");
            this.config = config;
            this.secondsArg = this.withRequiredArg("seconds", "Interval in seconds", (ArgumentType)ArgTypes.FLOAT);
        }

        protected void executeSync(@Nonnull CommandContext ctx) {
            Float seconds = (Float)ctx.get(this.secondsArg);
            if (seconds != null) {
                ((RegenConfig)this.config.get()).setIntervalSeconds(seconds.floatValue());
                this.config.save();
                ctx.sendMessage(Message.raw((String)("Interval set to " + seconds + " seconds")));
            }
        }
    }
}

