/*
 * Decompiled with CFR 0.152.
 */
package org.toskan4134.NaturalRegeneration;

import com.hypixel.hytale.logger.HytaleLogger;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DamageTracker {
    private static final HytaleLogger LOGGER = HytaleLogger.forEnclosingClass();
    private static final Map<Integer, Long> lastDamageTime = new ConcurrentHashMap<Integer, Long>();
    private static final long MAX_RECORD_AGE_MS = 600000L;
    private static long lastCleanupTime = 0L;
    private static final long CLEANUP_INTERVAL_MS = 60000L;

    public static void onDamageReceived(int entityIndex) {
        lastDamageTime.put(entityIndex, System.currentTimeMillis());
        DamageTracker.cleanupIfNeeded();
    }

    public static void onDamageReceived(int entityIndex, float damageAmount) {
        lastDamageTime.put(entityIndex, System.currentTimeMillis());
        DamageTracker.cleanupIfNeeded();
    }

    public static long getLastDamageTime(int entityIndex) {
        return lastDamageTime.getOrDefault(entityIndex, 0L);
    }

    public static boolean canRegenerate(int entityIndex, long currentTimeMs, long delayMs) {
        Long lastDamage = lastDamageTime.get(entityIndex);
        if (lastDamage == null) {
            return true;
        }
        return currentTimeMs - lastDamage >= delayMs;
    }

    public static void clearEntity(int entityIndex) {
        lastDamageTime.remove(entityIndex);
    }

    private static void cleanupIfNeeded() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCleanupTime < 60000L) {
            return;
        }
        lastCleanupTime = currentTime;
        Iterator<Map.Entry<Integer, Long>> iterator = lastDamageTime.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Long> entry = iterator.next();
            if (currentTime - entry.getValue() <= 600000L) continue;
            iterator.remove();
        }
        ((HytaleLogger.Api)LOGGER.atFine()).log("DamageTracker cleanup: " + lastDamageTime.size() + " active entries");
    }

    public static void clearAll() {
        lastDamageTime.clear();
    }

    public static int getActiveCount() {
        return lastDamageTime.size();
    }
}

