/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.disableddurability.event;

import com.hypixel.hytale.event.EventRegistry;
import com.hypixel.hytale.server.core.entity.Entity;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.event.events.entity.LivingEntityInventoryChangeEvent;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.natamus.disableddurability.config.ConfigHandler;

public class RegisterLivingEntityEvents {
    public static void init(EventRegistry eventRegistry) {
        eventRegistry.registerGlobal(LivingEntityInventoryChangeEvent.class, RegisterLivingEntityEvents::onLivingEntityInventoryChangeEvent);
    }

    private static void onLivingEntityInventoryChangeEvent(LivingEntityInventoryChangeEvent e) {
        if (!ConfigHandler.getConfigHandler().disableItemDurability) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemContainer itemContainer = e.getItemContainer();
        for (short slot = 0; slot < itemContainer.getCapacity(); slot = (short)(slot + 1)) {
            ItemStack slotStack = itemContainer.getItemStack(slot);
            if (slotStack == null || slotStack.isUnbreakable()) continue;
            double maxDurability = slotStack.getMaxDurability();
            if (!(slotStack.getDurability() < maxDurability)) continue;
            itemContainer.setItemStackForSlot(slot, slotStack.withDurability(maxDurability));
        }
    }
}

