/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.utils;

import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.math.iterator.CircleSpiralIterator;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.packets.worldmap.MapChunk;
import com.hypixel.hytale.protocol.packets.worldmap.UpdateWorldMap;
import com.hypixel.hytale.protocol.packets.worldmap.UpdateWorldMapSettings;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.WorldMapTracker;
import com.hypixel.hytale.server.core.universe.world.worldmap.WorldMapManager;
import com.hypixel.hytale.server.core.universe.world.worldmap.WorldMapSettings;
import dev.ninesliced.configs.BetterMapConfig;
import dev.ninesliced.configs.PlayerConfig;
import dev.ninesliced.exploration.ExplorationTracker;
import dev.ninesliced.managers.ExplorationManager;
import dev.ninesliced.managers.MapExpansionManager;
import dev.ninesliced.managers.PlayerConfigManager;
import dev.ninesliced.utils.ChunkUtil;
import dev.ninesliced.utils.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class WorldMapHook {
    private static final Logger LOGGER = Logger.getLogger(WorldMapHook.class.getName());

    public static void hookPlayerMapTracker(@Nonnull Player player, @Nonnull WorldMapTracker tracker) {
        try {
            ReflectionHelper.setFieldValueRecursive(tracker, "viewRadiusOverride", 999);
            World world = player.getWorld();
            if (world != null) {
                WorldMapHook.sendMapSettingsToPlayer(player);
            }
            ExplorationTracker.PlayerExplorationData explorationData = ExplorationTracker.getInstance().getOrCreatePlayerData(player);
            RestrictedSpiralIterator customIterator = new RestrictedSpiralIterator(explorationData, tracker);
            ReflectionHelper.setFieldValueRecursive(tracker, "spiralIterator", (Object)customIterator);
            LOGGER.info("Hooked map tracker for player: " + player.getDisplayName());
        }
        catch (Exception e) {
            LOGGER.warning("Failed to hook WorldMapTracker for player " + player.getDisplayName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void unhookPlayerMapTracker(@Nonnull Player player, @Nonnull WorldMapTracker tracker) {
        try {
            Object spiralIterator = ReflectionHelper.getFieldValueRecursive(tracker, "spiralIterator");
            if (spiralIterator instanceof RestrictedSpiralIterator) {
                ((RestrictedSpiralIterator)((Object)spiralIterator)).stop();
            }
            ReflectionHelper.setFieldValueRecursive(tracker, "viewRadiusOverride", null);
            try {
                Object pendingReloadFutures = ReflectionHelper.getFieldValueRecursive(tracker, "pendingReloadFutures");
                if (pendingReloadFutures instanceof Map) {
                    ((Map)pendingReloadFutures).clear();
                }
            }
            catch (Exception e) {
                LOGGER.warning("Could not clear pendingReloadFutures: " + e.getMessage());
            }
            try {
                Object pendingReloadChunks = ReflectionHelper.getFieldValueRecursive(tracker, "pendingReloadChunks");
                if (pendingReloadChunks instanceof Set) {
                    ((Set)pendingReloadChunks).clear();
                }
            }
            catch (Exception e) {
                LOGGER.warning("Could not clear pendingReloadChunks: " + e.getMessage());
            }
            try {
                ReflectionHelper.setFieldValueRecursive(tracker, "updateTimer", Float.valueOf(999.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.info("Unhooked map tracker for player: " + player.getDisplayName());
        }
        catch (Exception e) {
            LOGGER.warning("Error unhooking tracker for " + player.getDisplayName() + ": " + e.getMessage());
        }
    }

    public static void restoreVanillaMapTracker(@Nonnull Player player, @Nonnull WorldMapTracker tracker) {
        try {
            Object spiralIterator = ReflectionHelper.getFieldValueRecursive(tracker, "spiralIterator");
            if (spiralIterator instanceof RestrictedSpiralIterator) {
                ((RestrictedSpiralIterator)((Object)spiralIterator)).stop();
            }
            ReflectionHelper.setFieldValueRecursive(tracker, "viewRadiusOverride", null);
            ReflectionHelper.setFieldValueRecursive(tracker, "spiralIterator", new CircleSpiralIterator());
            ReflectionHelper.setFieldValueRecursive(tracker, "updateTimer", Float.valueOf(0.0f));
            LOGGER.info("Restored vanilla map tracker for player: " + player.getDisplayName());
        }
        catch (Exception e) {
            LOGGER.warning("Failed to restore vanilla tracker for " + player.getDisplayName() + ": " + e.getMessage());
        }
    }

    public static void hookWorldMapResolution(@Nonnull World world) {
        try {
            LOGGER.info("Hooking WorldMap resolution for world: " + world.getName());
            WorldMapManager manager = world.getWorldMapManager();
            LOGGER.info("Modifying WorldMapSettings for world: " + world.getName());
            WorldMapSettings settings = manager.getWorldMapSettings();
            BetterMapConfig.MapQuality quality = BetterMapConfig.getInstance().getActiveMapQuality();
            ReflectionHelper.setFieldValueRecursive(settings, "imageScale", Float.valueOf(quality.scale));
            manager.clearImages();
            LOGGER.info("Modified WorldMapSettings imageScale to " + quality.scale + " (" + String.valueOf((Object)quality) + " quality) for world: " + world.getName());
        }
        catch (Exception e) {
            LOGGER.warning("Failed to hook WorldMap resolution: " + e.getMessage());
        }
    }

    public static void updateExplorationState(@Nonnull Player player, @Nonnull WorldMapTracker tracker, double x, double z) {
        try {
            int playerChunkZ;
            int playerChunkX;
            boolean hasMoved;
            ExplorationTracker explorationTracker = ExplorationTracker.getInstance();
            ExplorationTracker.PlayerExplorationData explorationData = explorationTracker.getPlayerData(player);
            if (explorationData == null) {
                LOGGER.info("[DEBUG] No exploration data for " + player.getDisplayName() + " in updateExplorationState");
                return;
            }
            World world = player.getWorld();
            if (world != null) {
                explorationData.setWorldName(world.getName());
            }
            if (hasMoved = explorationData.hasMovedToNewChunk(playerChunkX = ChunkUtil.blockToChunkCoord(x), playerChunkZ = ChunkUtil.blockToChunkCoord(z))) {
                int explorationRadius = BetterMapConfig.getInstance().getExplorationRadius();
                explorationData.getMapExpansion().updateBoundaries(playerChunkX, playerChunkZ, explorationRadius);
                explorationData.setLastChunkPosition(playerChunkX, playerChunkZ);
                WorldMapHook.forceTrackerUpdate(player, tracker, x, z);
                int mapChunkX = playerChunkX >> 1;
                int mapChunkZ = playerChunkZ >> 1;
                WorldMapHook.manageLoadedChunks(player, tracker, mapChunkX, mapChunkZ);
            }
        }
        catch (Exception e) {
            LOGGER.warning("[DEBUG] Exception in updateExplorationState: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void manageLoadedChunks(@Nonnull Player player, @Nonnull WorldMapTracker tracker, int cx, int cz) {
        try {
            Object loadedObj = ReflectionHelper.getFieldValueRecursive(tracker, "loaded");
            if (!(loadedObj instanceof Set)) {
                return;
            }
            Set loaded = (Set)loadedObj;
            Object spiralIterator = ReflectionHelper.getFieldValueRecursive(tracker, "spiralIterator");
            if (!(spiralIterator instanceof RestrictedSpiralIterator)) {
                return;
            }
            List<Long> targetChunks = ((RestrictedSpiralIterator)((Object)spiralIterator)).getTargetMapChunks();
            HashSet<Long> targetSet = new HashSet<Long>(targetChunks);
            ArrayList<Long> toUnload = new ArrayList<Long>();
            ArrayList loadedSnapshot = new ArrayList(loaded);
            ArrayList<MapChunk> unloadPackets = new ArrayList<MapChunk>();
            for (Long idx : loadedSnapshot) {
                if (targetSet.contains(idx)) continue;
                toUnload.add(idx);
                int mx = com.hypixel.hytale.math.util.ChunkUtil.xOfChunkIndex((long)idx);
                int mz = com.hypixel.hytale.math.util.ChunkUtil.zOfChunkIndex((long)idx);
                unloadPackets.add(new MapChunk(mx, mz, null));
            }
            if (toUnload.isEmpty()) {
                return;
            }
            toUnload.forEach(loaded::remove);
            UpdateWorldMap packet = new UpdateWorldMap(unloadPackets.toArray(new MapChunk[0]), null, null);
            WorldMapHook.sendPacket(player, (Packet)packet);
        }
        catch (Exception e) {
            LOGGER.warning("Failed to manage loaded chunks: " + e.getMessage());
        }
    }

    private static void sendPacket(Player player, Packet packet) {
        PlayerRef playerRef;
        Ref ref = player.getReference();
        if (ref != null && ref.isValid() && (playerRef = (PlayerRef)ref.getStore().getComponent(ref, PlayerRef.getComponentType())) != null) {
            playerRef.getPacketHandler().write(packet);
        }
    }

    private static void forceTrackerUpdate(@Nonnull Player player, @Nonnull WorldMapTracker tracker, double x, double z) {
        try {
            Object spiralIterator = ReflectionHelper.getFieldValueRecursive(tracker, "spiralIterator");
            if (spiralIterator instanceof RestrictedSpiralIterator) {
                RestrictedSpiralIterator restrictedIterator = (RestrictedSpiralIterator)((Object)spiralIterator);
                int chunkX = (int)Math.floor(x) >> 5;
                int chunkZ = (int)Math.floor(z) >> 5;
                restrictedIterator.init(chunkX, chunkZ, 0, 999);
            }
            ReflectionHelper.setFieldValueRecursive(tracker, "updateTimer", Float.valueOf(0.0f));
        }
        catch (Exception e) {
            LOGGER.warning("[DEBUG] Failed to force tracker update: " + e.getMessage());
        }
    }

    public static void updateWorldMapConfigs(@Nonnull World world) {
        try {
            WorldMapSettings settings = world.getWorldMapManager().getWorldMapSettings();
            UpdateWorldMapSettings packet = (UpdateWorldMapSettings)ReflectionHelper.getFieldValue(settings, "settingsPacket");
            BetterMapConfig config = BetterMapConfig.getInstance();
            if (packet != null) {
                packet.minScale = config.getMinScale();
                packet.maxScale = config.getMaxScale();
            }
            ReflectionHelper.setFieldValueRecursive(settings, "minScale", Float.valueOf(config.getMinScale()));
            ReflectionHelper.setFieldValueRecursive(settings, "maxScale", Float.valueOf(config.getMaxScale()));
        }
        catch (Exception e) {
            LOGGER.warning("Failed to update world map configs: " + e.getMessage());
        }
    }

    public static void broadcastMapSettings(@Nonnull World world) {
        try {
            WorldMapManager mapManager = world.getWorldMapManager();
            Method sendSettings = mapManager.getClass().getMethod("sendSettings", new Class[0]);
            sendSettings.invoke((Object)mapManager, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.fine("Could not invoke mapManager.sendSettings(): " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMapSettingsToPlayer(@Nonnull Player player) {
        try {
            World world = player.getWorld();
            if (world == null) {
                return;
            }
            WorldMapHook.updateWorldMapConfigs(world);
            WorldMapSettings settings = world.getWorldMapManager().getWorldMapSettings();
            UpdateWorldMapSettings packet = (UpdateWorldMapSettings)ReflectionHelper.getFieldValue(settings, "settingsPacket");
            if (packet == null) {
                return;
            }
            UpdateWorldMapSettings updateWorldMapSettings = packet;
            synchronized (updateWorldMapSettings) {
                float originalMin = packet.minScale;
                float originalMax = packet.maxScale;
                PlayerConfig playerConfig = PlayerConfigManager.getInstance().getPlayerConfig(player.getUuid());
                if (playerConfig != null) {
                    packet.minScale = playerConfig.getMinScale();
                    packet.maxScale = playerConfig.getMaxScale();
                }
                WorldMapHook.sendPacket(player, (Packet)packet);
                if (playerConfig != null) {
                    packet.minScale = originalMin;
                    packet.maxScale = originalMax;
                }
            }
            LOGGER.fine("Sent custom map settings to " + player.getDisplayName());
        }
        catch (Exception e) {
            LOGGER.warning("Failed to send map settings to player: " + e.getMessage());
        }
    }

    public static void refreshTrackers(@Nonnull World world) {
        for (PlayerRef playerRef : world.getPlayerRefs()) {
            Player player;
            Holder holder = playerRef.getHolder();
            if (holder == null || (player = (Player)holder.getComponent(Player.getComponentType())) == null) continue;
            try {
                TransformComponent tc;
                Ref ref = playerRef.getReference();
                if (ref == null || !ref.isValid() || (tc = (TransformComponent)ref.getStore().getComponent(ref, TransformComponent.getComponentType())) == null) continue;
                Vector3d pos = tc.getPosition();
                WorldMapHook.forceTrackerUpdate(player, player.getWorldMapTracker(), pos.x, pos.z);
                WorldMapHook.updateExplorationState(player, player.getWorldMapTracker(), pos.x, pos.z);
            }
            catch (Exception e) {
                LOGGER.warning("Failed to refresh tracker for " + player.getDisplayName() + ": " + e.getMessage());
            }
        }
    }

    public static class RestrictedSpiralIterator
    extends CircleSpiralIterator {
        private final ExplorationTracker.PlayerExplorationData data;
        private final WorldMapTracker tracker;
        private Iterator<Long> currentIterator;
        private List<Long> targetMapChunks = new ArrayList<Long>();
        private int currentGoalRadius;
        private volatile boolean stopped = false;
        private int centerX;
        private int centerZ;
        private int currentRadius;
        private int cleanupTimer = 0;

        public RestrictedSpiralIterator(ExplorationTracker.PlayerExplorationData data, WorldMapTracker tracker) {
            this.data = data;
            this.tracker = tracker;
        }

        public void stop() {
            this.stopped = true;
        }

        public List<Long> getTargetMapChunks() {
            return this.targetMapChunks;
        }

        public void init(int cx, int cz, int startRadius, int endRadius) {
            Set<Long> exploredWorldChunks;
            if (this.stopped) {
                this.currentIterator = Collections.emptyIterator();
                return;
            }
            this.centerX = cx;
            this.centerZ = cz;
            this.currentRadius = startRadius;
            this.currentGoalRadius = endRadius;
            HashSet<Long> mapChunks = new HashSet<Long>();
            if (BetterMapConfig.getInstance().isShareAllExploration()) {
                World world = this.tracker.getPlayer().getWorld();
                String worldName = world != null ? world.getName() : "world";
                exploredWorldChunks = ExplorationManager.getInstance().getAllExploredChunks(worldName);
            } else {
                exploredWorldChunks = this.data.getExploredChunks().getExploredChunks();
            }
            for (Long chunkIdx : exploredWorldChunks) {
                int wx = ChunkUtil.indexToChunkX(chunkIdx);
                int wz = ChunkUtil.indexToChunkZ(chunkIdx);
                int mx = wx >> 1;
                int mz = wz >> 1;
                long mapChunkIdx = com.hypixel.hytale.math.util.ChunkUtil.indexChunk((int)mx, (int)mz);
                mapChunks.add(mapChunkIdx);
            }
            List<Long> rankedChunks = new ArrayList<Long>();
            MapExpansionManager.MapBoundaries bounds = this.data.getMapExpansion().getCurrentBoundaries();
            HashSet<Long> boundaryChunks = new HashSet<Long>();
            if (bounds.minX != Integer.MAX_VALUE) {
                boundaryChunks.add(com.hypixel.hytale.math.util.ChunkUtil.indexChunk((int)(bounds.minX >> 1), (int)(bounds.minZ >> 1)));
                boundaryChunks.add(com.hypixel.hytale.math.util.ChunkUtil.indexChunk((int)(bounds.maxX >> 1), (int)(bounds.minZ >> 1)));
                boundaryChunks.add(com.hypixel.hytale.math.util.ChunkUtil.indexChunk((int)(bounds.minX >> 1), (int)(bounds.maxZ >> 1)));
                boundaryChunks.add(com.hypixel.hytale.math.util.ChunkUtil.indexChunk((int)(bounds.maxX >> 1), (int)(bounds.maxZ >> 1)));
            }
            for (Long chunk : mapChunks) {
                if (boundaryChunks.contains(chunk)) continue;
                rankedChunks.add(chunk);
            }
            rankedChunks.sort(Comparator.comparingDouble(idx -> {
                int mx = com.hypixel.hytale.math.util.ChunkUtil.xOfChunkIndex((long)idx);
                int mz = com.hypixel.hytale.math.util.ChunkUtil.zOfChunkIndex((long)idx);
                return Math.sqrt(Math.pow(mx - cx, 2.0) + Math.pow(mz - cz, 2.0));
            }));
            int maxChunks = BetterMapConfig.getInstance().getActiveMapQuality().maxChunks;
            int searchLimit = maxChunks - boundaryChunks.size();
            if (searchLimit < 0) {
                searchLimit = 0;
            }
            if (rankedChunks.size() > searchLimit) {
                rankedChunks = rankedChunks.subList(0, searchLimit);
            }
            this.targetMapChunks = new ArrayList<Long>(boundaryChunks);
            this.targetMapChunks.addAll(rankedChunks);
            this.currentIterator = rankedChunks.iterator();
            if (++this.cleanupTimer > 100) {
                this.cleanupTimer = 0;
                this.cleanupFarChunks(rankedChunks);
            }
        }

        private void cleanupFarChunks(List<Long> keepChunks) {
            try {
                Set loadedSet;
                Object loadedObj = ReflectionHelper.getFieldValue(this.tracker, "loaded");
                if (loadedObj instanceof Set && (loadedSet = (Set)loadedObj).size() > 20000) {
                    HashSet<Long> keepSet = new HashSet<Long>(keepChunks);
                    ArrayList<MapChunk> toRemovePackets = new ArrayList<MapChunk>();
                    Iterator it = loadedSet.iterator();
                    while (it.hasNext()) {
                        Long idx;
                        Object obj = it.next();
                        if (!(obj instanceof Long) || keepSet.contains(idx = (Long)obj)) continue;
                        it.remove();
                        int mx = com.hypixel.hytale.math.util.ChunkUtil.xOfChunkIndex((long)idx);
                        int mz = com.hypixel.hytale.math.util.ChunkUtil.zOfChunkIndex((long)idx);
                        toRemovePackets.add(new MapChunk(mx, mz, null));
                    }
                    if (!toRemovePackets.isEmpty()) {
                        UpdateWorldMap packet = new UpdateWorldMap(toRemovePackets.toArray(new MapChunk[0]), null, null);
                        WorldMapHook.sendPacket(this.tracker.getPlayer(), (Packet)packet);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warning("Failed to cleanup far chunks: " + e.getMessage());
            }
        }

        public boolean hasNext() {
            if (this.stopped) {
                return false;
            }
            return this.currentIterator != null && this.currentIterator.hasNext();
        }

        public long next() {
            if (this.stopped || this.currentIterator == null) {
                return 0L;
            }
            long next = this.currentIterator.next();
            int mx = com.hypixel.hytale.math.util.ChunkUtil.xOfChunkIndex((long)next);
            int mz = com.hypixel.hytale.math.util.ChunkUtil.zOfChunkIndex((long)next);
            double dist = Math.sqrt(Math.pow(mx - this.centerX, 2.0) + Math.pow(mz - this.centerZ, 2.0));
            this.currentRadius = (int)dist;
            return next;
        }

        public int getCompletedRadius() {
            if (this.stopped) {
                return this.currentGoalRadius;
            }
            return this.currentRadius;
        }
    }
}

