/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.ui;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Transform;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.protocol.Position;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.protocol.packets.worldmap.MapMarker;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.PositionUtil;
import dev.ninesliced.managers.WaypointManager;
import dev.ninesliced.ui.WaypointMenuPage;
import dev.ninesliced.utils.PermissionsUtil;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WaypointEditPage
extends InteractiveCustomUIPage<EditData> {
    @Nullable
    private final String targetId;
    private String selectedColor = "Coordinate.png";
    private boolean global = false;
    private String nameInput = "";
    private String inputX = "0.00";
    private String inputY = "64.00";
    private String inputZ = "0.00";
    private boolean initialized = false;

    public WaypointEditPage(@Nonnull PlayerRef playerRef, @Nullable String targetId) {
        super(playerRef, CustomPageLifetime.CanDismiss, EditData.CODEC);
        this.targetId = targetId;
    }

    public void build(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder ui, @Nonnull UIEventBuilder events, @Nonnull Store<EntityStore> store) {
        ui.append("Pages/BetterMap/WaypointEdit.ui");
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player == null) {
            return;
        }
        if (!this.initialized) {
            if (this.targetId != null) {
                MapMarker marker = WaypointManager.getWaypoint(player, this.targetId);
                if (marker != null) {
                    this.nameInput = marker.name != null ? marker.name : "";
                    this.selectedColor = marker.markerImage;
                    Position pos = marker.transform.position;
                    this.inputX = String.format(Locale.ROOT, "%.2f", pos.x);
                    this.inputY = String.format(Locale.ROOT, "%.2f", pos.y);
                    this.inputZ = String.format(Locale.ROOT, "%.2f", pos.z);
                    this.global = marker.id != null && marker.id.startsWith("global_waypoint_");
                }
            } else {
                TransformComponent transform = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
                if (transform != null) {
                    Vector3d pos = transform.getPosition();
                    this.inputX = String.format(Locale.ROOT, "%.2f", pos.x);
                    this.inputY = String.format(Locale.ROOT, "%.2f", pos.y);
                    this.inputZ = String.format(Locale.ROOT, "%.2f", pos.z);
                }
            }
            this.initialized = true;
        }
        ui.set("#NameInput.Value", this.nameInput);
        ui.set("#InputX.Value", this.inputX);
        ui.set("#InputY.Value", this.inputY);
        ui.set("#InputZ.Value", this.inputZ);
        ui.set("#SelRed.Visible", "RedMarker.png".equals(this.selectedColor));
        ui.set("#SelGreen.Visible", "GreenMarker.png".equals(this.selectedColor));
        ui.set("#SelBlue.Visible", "BlueMarker.png".equals(this.selectedColor));
        ui.set("#SelWhite.Visible", "Coordinate.png".equals(this.selectedColor));
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#NameInput", new EventData().put("@NameInput", "#NameInput.Value"), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#InputX", new EventData().put("@InputX", "#InputX.Value"), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#InputY", new EventData().put("@InputY", "#InputY.Value"), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#InputZ", new EventData().put("@InputZ", "#InputZ.Value"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#SaveButton", new EventData().put("Action", Action.SAVE.name()), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#CancelButton", new EventData().put("Action", Action.CANCEL.name()), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#ColorRed", new EventData().put("Action", Action.SET_RED.name()), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#ColorGreen", new EventData().put("Action", Action.SET_GREEN.name()), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#ColorBlue", new EventData().put("Action", Action.SET_BLUE.name()), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#ColorWhite", new EventData().put("Action", Action.SET_WHITE.name()), false);
    }

    public void handleDataEvent(@Nonnull Ref<EntityStore> ref, @Nonnull Store<EntityStore> store, @Nonnull EditData data) {
        Action action;
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player == null) {
            return;
        }
        if (data.nameInput != null) {
            this.nameInput = data.nameInput;
        }
        if (data.inputX != null) {
            this.inputX = data.inputX;
        }
        if (data.inputY != null) {
            this.inputY = data.inputY;
        }
        if (data.inputZ != null) {
            this.inputZ = data.inputZ;
        }
        if (data.global != null) {
            this.global = data.global;
        }
        if (data.action == null) {
            return;
        }
        try {
            action = Action.valueOf(data.action);
        }
        catch (Exception e) {
            return;
        }
        boolean canGlobal = PermissionsUtil.canUseGlobalWaypoints(player);
        if (this.targetId != null && this.targetId.startsWith("global_waypoint_") && !canGlobal) {
            return;
        }
        switch (action.ordinal()) {
            case 2: {
                this.selectedColor = "RedMarker.png";
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
                break;
            }
            case 3: {
                this.selectedColor = "GreenMarker.png";
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
                break;
            }
            case 4: {
                this.selectedColor = "BlueMarker.png";
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
                break;
            }
            case 5: {
                this.selectedColor = "Coordinate.png";
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
                break;
            }
            case 1: {
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new WaypointMenuPage(this.playerRef));
                break;
            }
            case 0: {
                boolean wantsGlobal;
                String newName = this.nameInput.trim();
                if (newName.isEmpty()) {
                    newName = this.generateDefaultName(player, this.targetId == null);
                }
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                try {
                    x = Double.parseDouble(this.inputX);
                    y = Double.parseDouble(this.inputY);
                    z = Double.parseDouble(this.inputZ);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Transform newVecTransform = new Transform(x, y, z);
                com.hypixel.hytale.protocol.Transform packetTransform = PositionUtil.toTransformPacket((Transform)newVecTransform);
                boolean bl = wantsGlobal = this.global && canGlobal;
                if (this.targetId != null) {
                    boolean wasGlobal;
                    MapMarker old = WaypointManager.getWaypoint(player, this.targetId);
                    boolean bl2 = wasGlobal = old != null && old.id != null && old.id.startsWith("global_waypoint_");
                    if (wantsGlobal != wasGlobal && old != null) {
                        WaypointManager.removeWaypoint(player, this.targetId);
                        WaypointManager.addWaypoint(player, newName, this.selectedColor, packetTransform, wantsGlobal);
                    } else if (old != null) {
                        WaypointManager.updateWaypoint(player, this.targetId, newName, this.selectedColor, packetTransform);
                    }
                } else {
                    WaypointManager.addWaypoint(player, newName, this.selectedColor, packetTransform, wantsGlobal);
                }
                WaypointMenuPage menuPage = new WaypointMenuPage(this.playerRef);
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)menuPage);
            }
        }
    }

    private String generateDefaultName(@Nonnull Player player, boolean isNew) {
        MapMarker[] markers = WaypointManager.getWaypoints(player);
        int count = markers != null ? markers.length : 0;
        int suffix = isNew ? count + 1 : Math.max(count, 1);
        return "Waypoint" + suffix;
    }

    public static class EditData {
        public static final String KEY_ACTION = "Action";
        public static final String KEY_NAME_INPUT = "@NameInput";
        public static final String KEY_INPUT_X = "@InputX";
        public static final String KEY_INPUT_Y = "@InputY";
        public static final String KEY_INPUT_Z = "@InputZ";
        public static final String KEY_GLOBAL = "@Global";
        public String action;
        public String nameInput;
        public String inputX;
        public String inputY;
        public String inputZ;
        public Boolean global;
        public static final BuilderCodec<EditData> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(EditData.class, EditData::new).addField(new KeyedCodec("Action", (Codec)Codec.STRING), (data, value) -> {
            data.action = value;
        }, data -> data.action)).addField(new KeyedCodec("@NameInput", (Codec)Codec.STRING), (data, value) -> {
            data.nameInput = value;
        }, data -> data.nameInput)).addField(new KeyedCodec("@InputX", (Codec)Codec.STRING), (data, value) -> {
            data.inputX = value;
        }, data -> data.inputX)).addField(new KeyedCodec("@InputY", (Codec)Codec.STRING), (data, value) -> {
            data.inputY = value;
        }, data -> data.inputY)).addField(new KeyedCodec("@InputZ", (Codec)Codec.STRING), (data, value) -> {
            data.inputZ = value;
        }, data -> data.inputZ)).addField(new KeyedCodec("@Global", (Codec)Codec.BOOLEAN), (data, value) -> {
            data.global = value;
        }, data -> data.global)).build();
    }

    static enum Action {
        SAVE,
        CANCEL,
        SET_RED,
        SET_GREEN,
        SET_BLUE,
        SET_WHITE;

    }
}

