/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.systems;

import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.tick.EntityTickingSystem;
import com.hypixel.hytale.server.core.entity.EntityUtils;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.ninesliced.BetterMap;
import dev.ninesliced.providers.LocationHudProvider;
import javax.annotation.Nonnull;

public class LocationSystem
extends EntityTickingSystem<EntityStore> {
    private final Query<EntityStore> query = Query.and((Query[])new Query[]{Player.getComponentType()});

    @Nonnull
    public Query<EntityStore> getQuery() {
        return this.query;
    }

    public void tick(float dt, int index, @Nonnull ArchetypeChunk<EntityStore> archetypeChunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
        Holder holder = EntityUtils.toHolder((int)index, archetypeChunk);
        Player player = (Player)holder.getComponent(Player.getComponentType());
        PlayerRef playerRef = (PlayerRef)holder.getComponent(PlayerRef.getComponentType());
        if (player == null || playerRef == null) {
            return;
        }
        LocationHudProvider provider = BetterMap.get().getLocationHudProvider();
        if (provider != null) {
            provider.showHud(dt, index, archetypeChunk, store, commandBuffer);
        }
    }
}

