/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.providers;

import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.protocol.Direction;
import com.hypixel.hytale.protocol.Position;
import com.hypixel.hytale.protocol.Transform;
import com.hypixel.hytale.protocol.packets.worldmap.MapMarker;
import com.hypixel.hytale.server.core.asset.type.gameplay.GameplayConfig;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.WorldMapTracker;
import com.hypixel.hytale.server.core.universe.world.worldmap.WorldMapManager;
import dev.ninesliced.configs.BetterMapConfig;
import dev.ninesliced.managers.PlayerRadarManager;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;

public class PlayerRadarProvider
implements WorldMapManager.MarkerProvider {
    private static final Logger LOGGER = Logger.getLogger(PlayerRadarProvider.class.getName());
    private static final String MARKER_PREFIX = "PlayerRadar-";
    private static final String MARKER_ICON = "Player.png";
    public static final String PROVIDER_ID = "BetterMapPlayerRadar";

    public void update(World world, GameplayConfig gameplayConfig, WorldMapTracker tracker, int viewRadius, int chunkX, int chunkZ) {
        try {
            Player viewingPlayer = tracker.getPlayer();
            UUID viewerUuid = viewingPlayer.getUuid();
            BetterMapConfig config = BetterMapConfig.getInstance();
            if (!config.isRadarEnabled() || config.isHidePlayersOnMap()) {
                return;
            }
            List<PlayerRadarManager.RadarData> radarDataList = PlayerRadarManager.getInstance().getRadarData(world.getName());
            PlayerRadarManager.RadarData viewerData = null;
            for (PlayerRadarManager.RadarData data : radarDataList) {
                if (!data.uuid.equals(viewerUuid.toString())) continue;
                viewerData = data;
                break;
            }
            if (viewerData == null) {
                return;
            }
            Vector3d viewerPos = viewerData.position;
            int radarRange = config.getRadarRange();
            boolean infiniteRange = radarRange < 0;
            int rangeSquared = infiniteRange ? Integer.MAX_VALUE : radarRange * radarRange;
            for (PlayerRadarManager.RadarData otherData : radarDataList) {
                if (otherData.uuid.equals(viewerUuid.toString())) continue;
                try {
                    Vector3d otherPos = otherData.position;
                    double dx = otherPos.x - viewerPos.x;
                    double dy = otherPos.y - viewerPos.y;
                    double dz = otherPos.z - viewerPos.z;
                    double distanceSquared = dx * dx + dy * dy + dz * dz;
                    if (!infiniteRange && distanceSquared > (double)rangeSquared) continue;
                    int distance = (int)Math.sqrt(distanceSquared);
                    String markerId = MARKER_PREFIX + otherData.uuid;
                    String markerName = otherData.name + " (" + distance + "m)";
                    MapMarker marker = this.createPlayerMarker(markerId, markerName, otherPos, otherData.rotation);
                    tracker.trySendMarker(viewRadius, chunkX, chunkZ, marker);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            LOGGER.warning("Error in PlayerRadarProvider.update: " + e.getMessage());
        }
    }

    private MapMarker createPlayerMarker(String id, String name, Vector3d position, Vector3f rotation) {
        Transform transform = new Transform();
        transform.position = new Position(position.x, position.y, position.z);
        transform.orientation = new Direction(rotation != null ? rotation.x : 0.0f, rotation != null ? rotation.y : 0.0f, rotation != null ? rotation.z : 0.0f);
        return new MapMarker(id, name, MARKER_ICON, transform, null);
    }
}

