/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.providers;

import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.entity.EntityUtils;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.hud.CustomUIHud;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.ninesliced.configs.PlayerConfig;
import dev.ninesliced.hud.LocationHud;
import dev.ninesliced.managers.PlayerConfigManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class LocationHudProvider {
    private final Map<PlayerRef, LocationHud> huds = new HashMap<PlayerRef, LocationHud>();

    public void showHud(float dt, int index, @Nonnull ArchetypeChunk<EntityStore> archetypeChunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
        Holder holder = EntityUtils.toHolder((int)index, archetypeChunk);
        Player player = (Player)holder.getComponent(Player.getComponentType());
        PlayerRef playerRef = (PlayerRef)holder.getComponent(PlayerRef.getComponentType());
        if (player == null || playerRef == null) {
            return;
        }
        if (!this.huds.containsKey(playerRef)) {
            LocationHud hud = new LocationHud(playerRef);
            this.huds.put(playerRef, hud);
            player.getHudManager().setCustomHud(playerRef, (CustomUIHud)hud);
        }
        PlayerConfig config = PlayerConfigManager.getInstance().getPlayerConfig(playerRef.getUuid());
        LocationHud hud = this.huds.get(playerRef);
        hud.setEnabled(config != null && config.isLocationEnabled());
        hud.updateHud(dt, index, archetypeChunk, store, commandBuffer);
        hud.show();
    }

    public void removeHud(@Nonnull PlayerRef playerRef) {
        this.huds.remove(playerRef);
    }

    public boolean hasHudForPlayer(@Nonnull PlayerRef playerRef) {
        return this.huds.containsKey(playerRef);
    }

    public void enableHudForPlayer(@Nonnull Player player, @Nonnull PlayerRef playerRef) {
        PlayerConfig config = PlayerConfigManager.getInstance().getPlayerConfig(playerRef.getUuid());
        if (!this.huds.containsKey(playerRef)) {
            try {
                LocationHud locationHud = new LocationHud(playerRef);
                this.huds.put(playerRef, locationHud);
                locationHud.setEnabled(true);
                player.getHudManager().setCustomHud(playerRef, (CustomUIHud)locationHud);
            }
            catch (Exception e) {
                this.huds.remove(playerRef);
                config.setLocationEnabled(false);
                throw e;
            }
        } else {
            LocationHud hud = this.huds.get(playerRef);
            hud.setEnabled(true);
            hud.show();
        }
    }

    public void enableHudForPlayer(@Nonnull PlayerRef playerRef) {
        PlayerConfig config = PlayerConfigManager.getInstance().getPlayerConfig(playerRef.getUuid());
        config.setLocationEnabled(true);
    }

    public void disableHudForPlayer(@Nonnull PlayerRef playerRef) {
        if (this.huds.containsKey(playerRef)) {
            LocationHud hud = this.huds.get(playerRef);
            hud.setEnabled(false);
        }
    }

    public void cleanup() {
        this.huds.clear();
    }
}

