/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.managers;

import com.hypixel.hytale.math.vector.Transform;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.worldmap.WorldMapManager;
import dev.ninesliced.providers.PlayerRadarProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class PlayerRadarManager {
    private static final Logger LOGGER = Logger.getLogger(PlayerRadarManager.class.getName());
    private static PlayerRadarManager instance;
    private final Set<String> registeredWorlds = new HashSet<String>();
    private final Map<String, List<RadarData>> worldRadarCache = new ConcurrentHashMap<String, List<RadarData>>();
    private final PlayerRadarProvider radarProvider = new PlayerRadarProvider();

    private PlayerRadarManager() {
    }

    public static synchronized PlayerRadarManager getInstance() {
        if (instance == null) {
            instance = new PlayerRadarManager();
        }
        return instance;
    }

    public PlayerRadarProvider getRadarProvider() {
        return this.radarProvider;
    }

    public void updateRadarData(@Nonnull World world) {
        ArrayList<RadarData> radarDataList = new ArrayList<RadarData>();
        try {
            for (PlayerRef playerRef : world.getPlayerRefs()) {
                Transform transform = playerRef.getTransform();
                Vector3d pos = transform.getPosition();
                RadarData data = new RadarData(playerRef.getUuid().toString(), playerRef.getUsername(), new Vector3d(pos.x, pos.y, pos.z), transform.getRotation());
                radarDataList.add(data);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.worldRadarCache.put(world.getName(), radarDataList);
    }

    public List<RadarData> getRadarData(String worldName) {
        return this.worldRadarCache.getOrDefault(worldName, Collections.emptyList());
    }

    public void registerForPlayer(@Nonnull Player player) {
        World world = player.getWorld();
        if (world == null) {
            LOGGER.warning("Cannot register radar provider: player world is null");
            return;
        }
        this.registerForWorld(world);
    }

    public void registerForWorld(@Nonnull World world) {
        String worldName = world.getName();
        if (this.registeredWorlds.contains(worldName)) {
            return;
        }
        try {
            WorldMapManager mapManager = world.getWorldMapManager();
            if (mapManager == null) {
                LOGGER.warning("Cannot register radar provider: WorldMapManager is null for world " + worldName);
                return;
            }
            if (!mapManager.getMarkerProviders().containsKey("BetterMapPlayerRadar")) {
                mapManager.addMarkerProvider("BetterMapPlayerRadar", (WorldMapManager.MarkerProvider)this.radarProvider);
                this.registeredWorlds.add(worldName);
                LOGGER.info("Registered PlayerRadarProvider for world: " + worldName);
            } else {
                this.registeredWorlds.add(worldName);
            }
        }
        catch (Exception e) {
            LOGGER.warning("Failed to register radar provider for world " + worldName + ": " + e.getMessage());
        }
    }

    public void unregisterForWorld(@Nonnull String worldName) {
        this.registeredWorlds.remove(worldName);
        LOGGER.info("Unregistered PlayerRadarProvider for world: " + worldName);
    }

    public void cleanup() {
        this.registeredWorlds.clear();
        LOGGER.info("PlayerRadarManager cleaned up");
    }

    public static class RadarData {
        public final String uuid;
        public final String name;
        public final Vector3d position;
        public final Vector3f rotation;

        public RadarData(String uuid, String name, Vector3d position, Vector3f rotation) {
            this.uuid = uuid;
            this.name = name;
            this.position = position;
            this.rotation = rotation;
        }
    }
}

