/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.ninesliced.configs.BetterMapConfig;
import dev.ninesliced.configs.PlayerConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class PlayerConfigManager {
    private static final Logger LOGGER = Logger.getLogger(PlayerConfigManager.class.getName());
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static PlayerConfigManager INSTANCE;
    private final Path configDir;
    private final Map<UUID, PlayerConfig> playerConfigs = new ConcurrentHashMap<UUID, PlayerConfig>();

    private PlayerConfigManager(Path rootDir) {
        this.configDir = rootDir.resolve("player_configs");
        try {
            if (!Files.exists(this.configDir, new LinkOption[0])) {
                Files.createDirectories(this.configDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LOGGER.severe("Failed to create player_configs directory: " + e.getMessage());
        }
    }

    public static synchronized void initialize(Path rootDir) {
        if (INSTANCE == null) {
            INSTANCE = new PlayerConfigManager(rootDir);
        }
    }

    public static PlayerConfigManager getInstance() {
        return INSTANCE;
    }

    public PlayerConfig getPlayerConfig(UUID uuid) {
        if (!this.playerConfigs.containsKey(uuid)) {
            this.loadPlayerConfig(uuid);
        }
        return this.playerConfigs.get(uuid);
    }

    public void loadPlayerConfig(UUID uuid) {
        Path configFile = this.configDir.resolve(uuid.toString() + ".json");
        PlayerConfig config = null;
        if (Files.exists(configFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                config = (PlayerConfig)GSON.fromJson((Reader)reader, PlayerConfig.class);
                if (config != null) {
                    config.setPlayerUuid(uuid);
                }
            }
            catch (IOException e) {
                LOGGER.warning("Failed to load config for player " + String.valueOf(uuid) + ", using defaults: " + e.getMessage());
            }
        }
        if (config == null) {
            config = this.createDefaultConfig(uuid);
        }
        this.playerConfigs.put(uuid, config);
        LOGGER.info("Loaded config for player: " + String.valueOf(uuid));
    }

    public void savePlayerConfig(UUID uuid) {
        PlayerConfig config = this.playerConfigs.get(uuid);
        if (config == null) {
            return;
        }
        Path configFile = this.configDir.resolve(uuid.toString() + ".json");
        try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.warning("Failed to save config for player " + String.valueOf(uuid) + ": " + e.getMessage());
        }
    }

    public void unloadPlayerConfig(UUID uuid) {
        this.savePlayerConfig(uuid);
        this.playerConfigs.remove(uuid);
        LOGGER.info("Unloaded config for player: " + String.valueOf(uuid));
    }

    private PlayerConfig createDefaultConfig(UUID uuid) {
        BetterMapConfig mainConfig = BetterMapConfig.getInstance();
        return new PlayerConfig(uuid, mainConfig.getMinScale(), mainConfig.getMaxScale(), mainConfig.isLocationEnabled());
    }
}

