/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.managers;

import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.event.events.player.PlayerConnectEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerReadyEvent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.WorldMapTracker;
import com.hypixel.hytale.server.core.universe.world.worldmap.WorldMapManager;
import dev.ninesliced.BetterMap;
import dev.ninesliced.configs.BetterMapConfig;
import dev.ninesliced.managers.PlayerRadarManager;
import dev.ninesliced.utils.PermissionsUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class MapPrivacyManager {
    private static final Logger LOGGER = Logger.getLogger(MapPrivacyManager.class.getName());
    private static MapPrivacyManager instance;
    private final Set<World> monitoredWorlds = Collections.newSetFromMap(new WeakHashMap());
    private final Map<World, Map<String, WorldMapManager.MarkerProvider>> backedUpProviders = new WeakHashMap<World, Map<String, WorldMapManager.MarkerProvider>>();

    private MapPrivacyManager() {
    }

    public static synchronized MapPrivacyManager getInstance() {
        if (instance == null) {
            instance = new MapPrivacyManager();
        }
        return instance;
    }

    public void initialize() {
        BetterMap plugin = BetterMap.get();
        if (plugin == null) {
            LOGGER.severe("BetterMap instance is null, cannot initialize MapPrivacyManager");
            return;
        }
        plugin.getEventRegistry().registerGlobal(PlayerConnectEvent.class, event -> {
            PlayerRef playerRef = event.getPlayerRef();
            if (playerRef == null) {
                return;
            }
            Holder holder = playerRef.getHolder();
            if (holder == null) {
                return;
            }
            Player player = (Player)holder.getComponent(Player.getComponentType());
            if (player == null) {
                return;
            }
            this.applyPlayerSettings(player, event.getWorld());
        });
        plugin.getEventRegistry().registerGlobal(PlayerReadyEvent.class, event -> this.applyPlayerSettings(event.getPlayer(), event.getPlayer().getWorld()));
        HytaleServer.SCHEDULED_EXECUTOR.scheduleAtFixedRate(() -> {
            try {
                if (!BetterMapConfig.getInstance().isHidePlayersOnMap()) {
                    return;
                }
                for (World world : this.monitoredWorlds) {
                    if (world == null) continue;
                    this.removeProvider(world);
                }
            }
            catch (Exception e) {
                LOGGER.warning("Error in privacy provider poller: " + e.getMessage());
            }
        }, 5L, 30L, TimeUnit.SECONDS);
        LOGGER.info("MapPrivacyManager initialized.");
    }

    public void updatePrivacyState() {
        BetterMapConfig config = BetterMapConfig.getInstance();
        boolean hide = config.isHidePlayersOnMap();
        boolean radarEnabled = config.isRadarEnabled();
        int radarRange = config.getRadarRange();
        boolean allowMarkerTeleports = config.isAllowMapMarkerTeleports();
        try {
            for (World world : this.monitoredWorlds) {
                if (world == null) continue;
                world.execute(() -> {
                    if (hide) {
                        this.removeProvider(world);
                    } else {
                        this.restoreProvider(world);
                    }
                    try {
                        for (PlayerRef playerRef : world.getPlayerRefs()) {
                            Player player;
                            Holder holder;
                            if (playerRef == null || (holder = playerRef.getHolder()) == null || (player = (Player)holder.getComponent(Player.getComponentType())) == null) continue;
                            WorldMapTracker tracker = player.getWorldMapTracker();
                            if (hide) {
                                tracker.setPlayerMapFilter(ignored -> false);
                            } else if (radarEnabled && radarRange >= 0) {
                                int rangeSq = radarRange * radarRange;
                                String worldName = world.getName();
                                String viewerUuid = playerRef.getUuid().toString();
                                tracker.setPlayerMapFilter(otherPlayer -> {
                                    try {
                                        Store store;
                                        PlayerRef otherPlayerRef;
                                        List<PlayerRadarManager.RadarData> radarDataList = PlayerRadarManager.getInstance().getRadarData(worldName);
                                        PlayerRadarManager.RadarData viewerData = null;
                                        for (PlayerRadarManager.RadarData data : radarDataList) {
                                            if (!data.uuid.equals(viewerUuid)) continue;
                                            viewerData = data;
                                            break;
                                        }
                                        if (viewerData == null) {
                                            return true;
                                        }
                                        String otherUuid = null;
                                        Ref otherRef = otherPlayer.getReference();
                                        if (otherRef != null && (otherPlayerRef = (PlayerRef)(store = otherRef.getStore()).getComponent(otherRef, PlayerRef.getComponentType())) != null) {
                                            otherUuid = otherPlayerRef.getUuid().toString();
                                        }
                                        if (otherUuid == null) {
                                            return true;
                                        }
                                        PlayerRadarManager.RadarData otherData = null;
                                        for (PlayerRadarManager.RadarData data : radarDataList) {
                                            if (!data.uuid.equals(otherUuid)) continue;
                                            otherData = data;
                                            break;
                                        }
                                        if (otherData == null) {
                                            return true;
                                        }
                                        double dx = otherData.position.x - viewerData.position.x;
                                        double dy = otherData.position.y - viewerData.position.y;
                                        double dz = otherData.position.z - viewerData.position.z;
                                        double distanceSquared = dx * dx + dy * dy + dz * dz;
                                        return distanceSquared <= (double)rangeSq;
                                    }
                                    catch (Exception e) {
                                        return true;
                                    }
                                });
                            } else {
                                tracker.setPlayerMapFilter(null);
                            }
                            boolean canTeleportMarkers = allowMarkerTeleports && PermissionsUtil.canTeleport(player);
                            tracker.setAllowTeleportToMarkers(world, canTeleportMarkers);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.severe("Error updating privacy state: " + e.getMessage());
        }
    }

    private void applyPlayerSettings(Player player, World world) {
        BetterMapConfig config = BetterMapConfig.getInstance();
        boolean hide = config.isHidePlayersOnMap();
        boolean radarEnabled = config.isRadarEnabled();
        int radarRange = config.getRadarRange();
        boolean allowMarkerTeleports = config.isAllowMapMarkerTeleports();
        if (world != null) {
            this.monitoredWorlds.add(world);
            if (hide) {
                this.removeProvider(world);
            } else {
                this.restoreProvider(world);
            }
        }
        try {
            WorldMapTracker tracker = player.getWorldMapTracker();
            if (hide) {
                tracker.setPlayerMapFilter(ignored -> false);
            } else if (radarEnabled && radarRange >= 0 && world != null) {
                String finalViewerUuid;
                Store store;
                PlayerRef pRef;
                int rangeSq = radarRange * radarRange;
                String worldName = world.getName();
                String viewerUuid = null;
                Ref ref = player.getReference();
                if (ref != null && (pRef = (PlayerRef)(store = ref.getStore()).getComponent(ref, PlayerRef.getComponentType())) != null) {
                    viewerUuid = pRef.getUuid().toString();
                }
                if ((finalViewerUuid = viewerUuid) != null) {
                    tracker.setPlayerMapFilter(otherPlayer -> {
                        try {
                            Store store;
                            PlayerRef otherPlayerRef;
                            List<PlayerRadarManager.RadarData> radarDataList = PlayerRadarManager.getInstance().getRadarData(worldName);
                            PlayerRadarManager.RadarData viewerData = null;
                            for (PlayerRadarManager.RadarData data : radarDataList) {
                                if (!data.uuid.equals(finalViewerUuid)) continue;
                                viewerData = data;
                                break;
                            }
                            if (viewerData == null) {
                                return true;
                            }
                            String otherUuid = null;
                            Ref otherRef = otherPlayer.getReference();
                            if (otherRef != null && (otherPlayerRef = (PlayerRef)(store = otherRef.getStore()).getComponent(otherRef, PlayerRef.getComponentType())) != null) {
                                otherUuid = otherPlayerRef.getUuid().toString();
                            }
                            if (otherUuid == null) {
                                return true;
                            }
                            PlayerRadarManager.RadarData otherData = null;
                            for (PlayerRadarManager.RadarData data : radarDataList) {
                                if (!data.uuid.equals(otherUuid)) continue;
                                otherData = data;
                                break;
                            }
                            if (otherData == null) {
                                return true;
                            }
                            double dx = otherData.position.x - viewerData.position.x;
                            double dy = otherData.position.y - viewerData.position.y;
                            double dz = otherData.position.z - viewerData.position.z;
                            double distanceSquared = dx * dx + dy * dy + dz * dz;
                            return distanceSquared <= (double)rangeSq;
                        }
                        catch (Exception e) {
                            return true;
                        }
                    });
                } else {
                    tracker.setPlayerMapFilter(null);
                }
            } else {
                tracker.setPlayerMapFilter(null);
            }
            boolean canTeleportMarkers = allowMarkerTeleports && PermissionsUtil.canTeleport(player);
            tracker.setAllowTeleportToMarkers(world, canTeleportMarkers);
        }
        catch (Exception e) {
            LOGGER.severe("Error applying privacy filter: " + e.getMessage());
        }
    }

    private void removeProvider(World world) {
        try {
            if (world == null) {
                return;
            }
            WorldMapManager mapManager = world.getWorldMapManager();
            Map providers = mapManager.getMarkerProviders();
            if (providers == null) {
                return;
            }
            List<String> targetKeys = Arrays.asList("playerMarkers", "playerIcons", "players");
            Map worldBackups = this.backedUpProviders.computeIfAbsent(world, ignored -> new HashMap());
            for (String key : targetKeys) {
                if (!providers.containsKey(key)) continue;
                worldBackups.put(key, (WorldMapManager.MarkerProvider)providers.get(key));
                providers.remove(key);
            }
        }
        catch (Exception e) {
            LOGGER.severe("Error removing provider: " + e.getMessage());
        }
    }

    private void restoreProvider(World world) {
        try {
            if (world == null) {
                return;
            }
            WorldMapManager mapManager = world.getWorldMapManager();
            Map providers = mapManager.getMarkerProviders();
            Map<String, WorldMapManager.MarkerProvider> backups = this.backedUpProviders.get(world);
            if (backups == null || backups.isEmpty()) {
                return;
            }
            this.backedUpProviders.remove(world);
            if (providers == null) {
                return;
            }
            for (Map.Entry<String, WorldMapManager.MarkerProvider> entry : backups.entrySet()) {
                if (providers.containsKey(entry.getKey())) continue;
                providers.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            LOGGER.severe("Error restoring provider: " + e.getMessage());
        }
    }
}

