/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.managers;

import dev.ninesliced.exploration.ExploredChunksTracker;
import dev.ninesliced.utils.ChunkUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class MapExpansionManager {
    private final ExploredChunksTracker exploredChunks;
    private int minChunkX = Integer.MAX_VALUE;
    private int maxChunkX = Integer.MIN_VALUE;
    private int minChunkZ = Integer.MAX_VALUE;
    private int maxChunkZ = Integer.MIN_VALUE;

    public MapExpansionManager(@Nonnull ExploredChunksTracker exploredChunks) {
        this.exploredChunks = exploredChunks;
    }

    public void updateBoundaries(int playerChunkX, int playerChunkZ, int viewRadius) {
        Set<Long> newChunks = ChunkUtil.getChunksInCircularArea(playerChunkX, playerChunkZ, viewRadius);
        for (long chunkIndex : newChunks) {
            int chunkX = ChunkUtil.indexToChunkX(chunkIndex);
            int chunkZ = ChunkUtil.indexToChunkZ(chunkIndex);
            this.minChunkX = Math.min(this.minChunkX, chunkX);
            this.maxChunkX = Math.max(this.maxChunkX, chunkX);
            this.minChunkZ = Math.min(this.minChunkZ, chunkZ);
            this.maxChunkZ = Math.max(this.maxChunkZ, chunkZ);
        }
        this.exploredChunks.markChunksExplored(newChunks);
    }

    @Nonnull
    public MapBoundaries getCurrentBoundaries() {
        if (this.minChunkX == Integer.MAX_VALUE) {
            return new MapBoundaries(0, 0, 0, 0);
        }
        return new MapBoundaries(this.minChunkX, this.maxChunkX, this.minChunkZ, this.maxChunkZ);
    }

    @Nonnull
    public Set<Long> getExpandedMapChunks() {
        if (this.minChunkX == Integer.MAX_VALUE) {
            return new HashSet<Long>();
        }
        return ChunkUtil.getChunksInRectangularArea(this.minChunkX, this.maxChunkX, this.minChunkZ, this.maxChunkZ);
    }

    public long getTotalExploredArea() {
        if (this.minChunkX == Integer.MAX_VALUE) {
            return 0L;
        }
        long width = this.maxChunkX - this.minChunkX + 1;
        long height = this.maxChunkZ - this.minChunkZ + 1;
        return width * height;
    }

    public void reset() {
        this.minChunkX = Integer.MAX_VALUE;
        this.maxChunkX = Integer.MIN_VALUE;
        this.minChunkZ = Integer.MAX_VALUE;
        this.maxChunkZ = Integer.MIN_VALUE;
        this.exploredChunks.clear();
    }

    public static class MapBoundaries {
        public final int minX;
        public final int maxX;
        public final int minZ;
        public final int maxZ;

        public MapBoundaries(int minX, int maxX, int minZ, int maxZ) {
            this.minX = minX;
            this.maxX = maxX;
            this.minZ = minZ;
            this.maxZ = maxZ;
        }

        public int getWidth() {
            return this.maxX - this.minX + 1;
        }

        public int getHeight() {
            return this.maxZ - this.minZ + 1;
        }

        public long getArea() {
            return (long)this.getWidth() * (long)this.getHeight();
        }

        public String toString() {
            return String.format("MapBoundaries{x:[%d,%d], z:[%d,%d], size:%dx%d}", this.minX, this.maxX, this.minZ, this.maxZ, this.getWidth(), this.getHeight());
        }
    }
}

