/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.managers;

import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.Universe;
import dev.ninesliced.configs.BetterMapConfig;
import dev.ninesliced.configs.ExplorationPersistence;
import dev.ninesliced.exploration.ExplorationTracker;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class ExplorationManager {
    private static final Logger LOGGER = Logger.getLogger(ExplorationManager.class.getName());
    private static ExplorationManager INSTANCE;
    private boolean initialized = false;
    private int maxStoredChunksPerPlayer = Integer.MAX_VALUE;
    private float explorationUpdateRate = 0.5f;
    private boolean persistenceEnabled = true;
    private ExplorationPersistence persistence;
    private String persistencePath = "universe/exploration_data";
    private final ScheduledExecutorService autoSaveScheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> autoSaveTask;

    private ExplorationManager() {
    }

    @Nonnull
    public static synchronized ExplorationManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExplorationManager();
        }
        return INSTANCE;
    }

    @Nonnull
    public static ConfigBuilder config() {
        return new ConfigBuilder();
    }

    public synchronized void initialize() {
        if (this.initialized) {
            LOGGER.info("Exploration system already initialized");
            return;
        }
        try {
            LOGGER.info("Initializing Exploration System...");
            this.persistence = new ExplorationPersistence();
            LOGGER.info("- Exploration Tracker: " + ExplorationTracker.class.getSimpleName());
            LOGGER.info("- Update Rate: " + this.explorationUpdateRate + " seconds");
            LOGGER.info("- Persistence: " + (this.persistenceEnabled ? "ENABLED" : "DISABLED"));
            this.startAutoSave();
            this.initialized = true;
            LOGGER.info("Exploration System initialized successfully");
        }
        catch (Exception e) {
            LOGGER.severe("Failed to initialize exploration system: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void loadPlayerData(@Nonnull Player player) {
        if (player.getWorld() != null) {
            this.loadPlayerData(player, player.getWorld().getName());
        }
    }

    public void loadPlayerData(@Nonnull Player player, @Nonnull String worldName) {
        if (this.persistenceEnabled && this.persistence != null) {
            this.persistence.load(player, worldName);
        }
    }

    public void savePlayerData(@Nonnull Player player) {
        if (this.persistenceEnabled && this.persistence != null) {
            this.persistence.save(player);
        }
    }

    public void savePlayerData(String playerName, UUID playerUUID, String worldName) {
        if (this.persistenceEnabled) {
            this.persistence.save(playerName, playerUUID, worldName);
        }
    }

    public Set<Long> getAllExploredChunks(String worldName) {
        Universe universe;
        HashSet<Long> allChunks = new HashSet<Long>();
        if (this.persistenceEnabled) {
            allChunks.addAll(this.persistence.loadAllChunks(worldName));
        }
        if ((universe = Universe.get()) != null) {
            for (ExplorationTracker.PlayerExplorationData data : ExplorationTracker.getInstance().getAllPlayerDataSnapshot().values()) {
                String dataWorld = data.getWorldName();
                if (dataWorld == null || !dataWorld.equals(worldName)) continue;
                allChunks.addAll(data.getExploredChunks().getExploredChunks());
            }
        }
        return allChunks;
    }

    public synchronized void shutdown() {
        try {
            LOGGER.info("Shutting down Exploration System...");
            this.stopAutoSave();
            this.autoSaveScheduler.shutdown();
            ExplorationTracker.getInstance().clear();
            LOGGER.info("Exploration System shutdown complete");
        }
        catch (Exception e) {
            LOGGER.severe("Error during exploration system shutdown: " + e.getMessage());
        }
    }

    public synchronized void startAutoSave() {
        this.stopAutoSave();
        int interval = BetterMapConfig.getInstance().getAutoSaveInterval();
        if (interval > 0) {
            this.autoSaveTask = this.autoSaveScheduler.scheduleAtFixedRate(this::autoSave, interval, interval, TimeUnit.MINUTES);
            LOGGER.info("Auto-save scheduled every " + interval + " minutes.");
        } else {
            LOGGER.info("Auto-save is disabled (interval <= 0).");
        }
    }

    public synchronized void stopAutoSave() {
        if (this.autoSaveTask != null) {
            this.autoSaveTask.cancel(false);
            this.autoSaveTask = null;
        }
    }

    private void autoSave() {
        if (!this.persistenceEnabled) {
            return;
        }
        this.persistence.saveAllPlayers();
        LOGGER.info("Auto-saved exploration data for all players.");
    }

    public void registerPlayer(@Nonnull Player player) {
        try {
            ExplorationTracker.getInstance().getOrCreatePlayerData(player);
            LOGGER.fine("Registered player for exploration tracking: " + player.getDisplayName());
        }
        catch (Exception e) {
            LOGGER.warning("Failed to register player " + player.getDisplayName() + ": " + e.getMessage());
        }
    }

    public void unregisterPlayer(@Nonnull Player player) {
        try {
            ExplorationTracker.getInstance().removePlayerData(player);
            LOGGER.fine("Unregistered player from exploration tracking: " + player.getDisplayName());
        }
        catch (Exception e) {
            LOGGER.warning("Failed to unregister player " + player.getDisplayName() + ": " + e.getMessage());
        }
    }

    public int getMaxStoredChunksPerPlayer() {
        return this.maxStoredChunksPerPlayer;
    }

    public void setMaxStoredChunksPerPlayer(int max) {
        this.maxStoredChunksPerPlayer = max;
        LOGGER.info("Max stored chunks per player set to: " + max);
    }

    public float getExplorationUpdateRate() {
        return this.explorationUpdateRate;
    }

    public void setExplorationUpdateRate(float seconds) {
        this.explorationUpdateRate = Math.max(0.1f, seconds);
        LOGGER.info("Exploration update rate set to: " + this.explorationUpdateRate + " seconds");
    }

    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    public void setPersistenceEnabled(boolean enabled) {
        this.persistenceEnabled = enabled;
        LOGGER.info("Persistence " + (enabled ? "enabled" : "disabled"));
    }

    public String getPersistencePath() {
        return this.persistencePath;
    }

    public void setPersistencePath(@Nonnull String path) {
        this.persistencePath = path;
        LOGGER.info("Persistence path set to: " + path);
    }

    public String toString() {
        return String.format("ExplorationManager{initialized=%s, maxChunksPerPlayer=%d, updateRate=%.2fs, persistence=%s}", this.initialized, this.maxStoredChunksPerPlayer, Float.valueOf(this.explorationUpdateRate), this.persistenceEnabled ? "enabled@" + this.persistencePath : "disabled");
    }

    public static class ConfigBuilder {
        private final ExplorationManager manager = ExplorationManager.getInstance();

        public ConfigBuilder maxChunksPerPlayer(int max) {
            this.manager.setMaxStoredChunksPerPlayer(max);
            return this;
        }

        public ConfigBuilder updateRate(float seconds) {
            this.manager.setExplorationUpdateRate(seconds);
            return this;
        }

        public ConfigBuilder enablePersistence(String path) {
            this.manager.setPersistencePath(path);
            this.manager.setPersistenceEnabled(true);
            return this;
        }

        public ConfigBuilder disablePersistence() {
            this.manager.setPersistenceEnabled(false);
            return this;
        }

        public ExplorationManager build() {
            this.manager.initialize();
            return this.manager;
        }
    }
}

