/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.hud;

import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.EntityUtils;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.hud.CustomUIHud;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.universe.world.worldgen.IWorldGen;
import com.hypixel.hytale.server.worldgen.biome.Biome;
import com.hypixel.hytale.server.worldgen.chunk.ChunkGenerator;
import com.hypixel.hytale.server.worldgen.chunk.ZoneBiomeResult;
import com.hypixel.hytale.server.worldgen.zone.Zone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LocationHud
extends CustomUIHud {
    @Nullable
    private Vector3d playerPosition;
    @Nullable
    private String worldName;
    @Nullable
    private String biomeName;
    @Nullable
    private String zoneName;
    private boolean isEnabled = true;

    public LocationHud(@Nonnull PlayerRef playerRef) {
        super(playerRef);
    }

    public void updateHud(float dt, int index, @Nonnull ArchetypeChunk<EntityStore> archetypeChunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
        if (!this.isEnabled) {
            return;
        }
        Holder holder = EntityUtils.toHolder((int)index, archetypeChunk);
        Player player = (Player)holder.getComponent(Player.getComponentType());
        TransformComponent transformComponent = (TransformComponent)holder.getComponent(TransformComponent.getComponentType());
        if (player != null && transformComponent != null && player.getWorld() != null) {
            this.playerPosition = transformComponent.getPosition().clone();
            this.worldName = player.getWorld().getName();
            this.updateBiomeAndZone(player.getWorld(), this.playerPosition);
        }
    }

    private void updateBiomeAndZone(World world, Vector3d position) {
        if (world == null || position == null) {
            return;
        }
        IWorldGen worldGen = world.getChunkStore().getGenerator();
        if (worldGen instanceof ChunkGenerator) {
            ChunkGenerator generator = (ChunkGenerator)worldGen;
            int seed = (int)world.getWorldConfig().getSeed();
            int x = (int)position.getX();
            int z = (int)position.getZ();
            try {
                ZoneBiomeResult result = generator.generateZoneBiomeResultAt(seed, x, z);
                Biome biome = result.getBiome();
                Zone zone = result.getZoneResult().getZone();
                this.biomeName = biome != null ? biome.getName() : "Unknown Biome";
                this.zoneName = zone != null ? zone.name() : "Unknown Zone";
            }
            catch (Exception e) {
                this.biomeName = "Error";
                this.zoneName = "Error";
            }
        } else {
            this.biomeName = "N/A";
            this.zoneName = "N/A";
        }
    }

    protected void build(@Nonnull UICommandBuilder ui) {
        if (!this.isEnabled) {
            return;
        }
        ui.append("Hud/Location/LocationDisplay.ui");
        ui.set("#Location #Background #Content #InfoPanel #WorldNameLabel.TextSpans", Message.raw((String)"World: Checking..."));
        ui.set("#Location #Background #Content #InfoPanel #BiomeNameLabel.TextSpans", Message.raw((String)"Biome: Checking..."));
        ui.set("#Location #Background #Content #InfoPanel #ZoneNameLabel.TextSpans", Message.raw((String)"Zone: Checking..."));
        ui.set("#Location #Background #Content #InfoPanel #PositionLabel.TextSpans", Message.raw((String)"Checking..."));
        if (this.playerPosition != null) {
            this.updateInfoDisplay(ui);
        }
    }

    private void updateInfoDisplay(@Nonnull UICommandBuilder ui) {
        if (!this.isEnabled) {
            return;
        }
        if (this.playerPosition == null) {
            return;
        }
        int x = (int)this.playerPosition.getX();
        int y = (int)this.playerPosition.getY();
        int z = (int)this.playerPosition.getZ();
        String positionText = String.format("Position: %d, %d, %d", x, y, z);
        ui.set("#Location #Background #Content #InfoPanel #PositionLabel.TextSpans", Message.raw((String)positionText));
        if (this.worldName != null) {
            ui.set("#Location #Background #Content #InfoPanel #WorldNameLabel.TextSpans", Message.raw((String)("World: " + this.worldName)));
        }
        if (this.biomeName != null) {
            ui.set("#Location #Background #Content #InfoPanel #BiomeNameLabel.TextSpans", Message.raw((String)("Biome: " + this.biomeName)));
        }
        if (this.zoneName != null) {
            ui.set("#Location #Background #Content #InfoPanel #ZoneNameLabel.TextSpans", Message.raw((String)("Zone: " + this.zoneName)));
        }
    }

    public String toString() {
        return "LocationHud{playerPosition=" + String.valueOf(this.playerPosition) + ", worldName='" + this.worldName + "', biomeName='" + this.biomeName + "', zoneName='" + this.zoneName + "'}";
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }
}

