/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.exploration;

import dev.ninesliced.components.ExplorationComponent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExploredChunksTracker {
    private final Set<Long> memoryExploredChunks;
    private final ExplorationComponent persistentComponent;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public ExploredChunksTracker(@Nullable ExplorationComponent component) {
        this.persistentComponent = component;
        this.memoryExploredChunks = component == null ? ConcurrentHashMap.newKeySet() : null;
    }

    public void markChunkExplored(long chunkIndex) {
        if (this.persistentComponent != null) {
            this.persistentComponent.addExploredChunk(chunkIndex);
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.memoryExploredChunks.add(chunkIndex);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markChunksExplored(@Nonnull Set<Long> chunkIndices) {
        if (this.persistentComponent != null) {
            for (Long chunk : chunkIndices) {
                this.persistentComponent.addExploredChunk(chunk);
            }
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.memoryExploredChunks.addAll(chunkIndices);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChunkExplored(long chunkIndex) {
        if (this.persistentComponent != null) {
            return this.persistentComponent.isExplored(chunkIndex);
        }
        this.lock.readLock().lock();
        try {
            boolean bl = this.memoryExploredChunks.contains(chunkIndex);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Nonnull
    public Set<Long> getExploredChunks() {
        if (this.persistentComponent != null) {
            return new HashSet<Long>((Collection<Long>)this.persistentComponent.getExploredChunks());
        }
        this.lock.readLock().lock();
        try {
            HashSet<Long> hashSet = new HashSet<Long>(this.memoryExploredChunks);
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getExploredCount() {
        if (this.persistentComponent != null) {
            return this.persistentComponent.getExploredChunks().size();
        }
        this.lock.readLock().lock();
        try {
            int n = this.memoryExploredChunks.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() {
        if (this.persistentComponent != null) {
            this.persistentComponent.getExploredChunks().clear();
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.memoryExploredChunks.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

