/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.exploration;

import com.hypixel.hytale.server.core.entity.entities.Player;
import dev.ninesliced.components.ExplorationComponent;
import dev.ninesliced.exploration.ExploredChunksTracker;
import dev.ninesliced.managers.MapExpansionManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExplorationTracker {
    private static final ExplorationTracker INSTANCE = new ExplorationTracker();
    private final Map<String, PlayerExplorationData> playerExplorationData = new ConcurrentHashMap<String, PlayerExplorationData>();

    private ExplorationTracker() {
    }

    @Nonnull
    public static ExplorationTracker getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public PlayerExplorationData getOrCreatePlayerData(@Nonnull Player player) {
        return this.getOrCreatePlayerData(player, null);
    }

    @Nonnull
    public PlayerExplorationData getOrCreatePlayerData(@Nonnull Player player, @Nullable ExplorationComponent component) {
        String playerName = player.getDisplayName();
        return this.playerExplorationData.compute(playerName, (k, v) -> {
            if (v == null) {
                return new PlayerExplorationData(component);
            }
            return v;
        });
    }

    public PlayerExplorationData getPlayerData(@Nonnull Player player) {
        return this.getPlayerData(player.getDisplayName());
    }

    public PlayerExplorationData getPlayerData(@Nonnull String playerName) {
        return this.playerExplorationData.get(playerName);
    }

    public void removePlayerData(@Nonnull Player player) {
        this.removePlayerData(player.getDisplayName());
    }

    public void removePlayerData(@Nonnull String playerName) {
        this.playerExplorationData.remove(playerName);
    }

    public void clear() {
        this.playerExplorationData.clear();
    }

    @Nonnull
    public Map<String, PlayerExplorationData> getAllPlayerDataSnapshot() {
        return new HashMap<String, PlayerExplorationData>(this.playerExplorationData);
    }

    public static class PlayerExplorationData {
        private final ExploredChunksTracker exploredChunks;
        private final MapExpansionManager mapExpansion;
        private long lastUpdateTime;
        private int lastChunkX = Integer.MAX_VALUE;
        private int lastChunkZ = Integer.MAX_VALUE;
        private volatile String worldName;

        public PlayerExplorationData(@Nullable ExplorationComponent component) {
            this.exploredChunks = new ExploredChunksTracker(component);
            this.mapExpansion = new MapExpansionManager(this.exploredChunks);
            this.lastUpdateTime = System.currentTimeMillis();
        }

        public ExploredChunksTracker getExploredChunks() {
            return this.exploredChunks;
        }

        public MapExpansionManager getMapExpansion() {
            return this.mapExpansion;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public void setLastUpdateTime(long time) {
            this.lastUpdateTime = time;
        }

        public int getLastChunkX() {
            return this.lastChunkX;
        }

        public int getLastChunkZ() {
            return this.lastChunkZ;
        }

        public void setLastChunkPosition(int chunkX, int chunkZ) {
            this.lastChunkX = chunkX;
            this.lastChunkZ = chunkZ;
        }

        public void resetLastChunkPosition() {
            this.lastChunkX = Integer.MAX_VALUE;
            this.lastChunkZ = Integer.MAX_VALUE;
        }

        @Nullable
        public String getWorldName() {
            return this.worldName;
        }

        public void setWorldName(@Nullable String worldName) {
            this.worldName = worldName;
        }

        public boolean hasMovedToNewChunk(int chunkX, int chunkZ) {
            return this.lastChunkX != chunkX || this.lastChunkZ != chunkZ;
        }
    }
}

