/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.exploration;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.WorldMapTracker;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.ninesliced.exploration.ExplorationTracker;
import dev.ninesliced.managers.PlayerRadarManager;
import dev.ninesliced.utils.WorldMapHook;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class ExplorationTicker {
    private static final Logger LOGGER = Logger.getLogger(ExplorationTicker.class.getName());
    private static ExplorationTicker INSTANCE;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private boolean isRunning = false;

    private ExplorationTicker() {
    }

    @Nonnull
    public static ExplorationTicker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExplorationTicker();
        }
        return INSTANCE;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.scheduler.scheduleAtFixedRate(this::tick, 1000L, 100L, TimeUnit.MILLISECONDS);
        LOGGER.info("Exploration Ticker started.");
    }

    public void scheduleUpdate(Runnable task) {
        if (!this.isRunning) {
            return;
        }
        this.scheduler.schedule(task, 50L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.isRunning = false;
        this.scheduler.shutdown();
    }

    private void tick() {
        if (!this.isRunning) {
            return;
        }
        Universe universe = Universe.get();
        if (universe == null) {
            return;
        }
        universe.getWorlds().values().forEach(world -> {
            try {
                world.execute(() -> {
                    this.updateWorldPlayers((World)world);
                    PlayerRadarManager.getInstance().updateRadarData((World)world);
                });
            }
            catch (IllegalThreadStateException its) {
                LOGGER.fine("[DEBUG] Skipping world update; world not accepting tasks: " + world.getName());
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateWorldPlayers(World world) {
        if (world != null && !world.isAlive()) {
            return;
        }
        try {
            for (PlayerRef ref : Universe.get().getPlayers()) {
                Ref playerRef = ref.getReference();
                if (playerRef == null || !playerRef.isValid()) continue;
                try {
                    ExplorationTracker.PlayerExplorationData data;
                    Player player;
                    if (((EntityStore)playerRef.getStore().getExternalData()).getWorld() != world || (player = (Player)playerRef.getStore().getComponent(playerRef, Player.getComponentType())) == null || (data = ExplorationTracker.getInstance().getPlayerData(player.getDisplayName())) == null) continue;
                    WorldMapTracker tracker = player.getWorldMapTracker();
                    TransformComponent tc = (TransformComponent)playerRef.getStore().getComponent(playerRef, TransformComponent.getComponentType());
                    if (tc == null) continue;
                    Vector3d pos = tc.getPosition();
                    WorldMapHook.updateExplorationState(player, tracker, pos.x, pos.z);
                }
                catch (IllegalThreadStateException its) {
                    return;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warning("ExplorationTicker failed: " + e.getMessage());
        }
    }
}

