/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.configs;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.server.core.entity.UUIDComponent;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.Universe;
import dev.ninesliced.exploration.ExplorationTracker;
import dev.ninesliced.utils.ChunkUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class ExplorationPersistence {
    private static final Logger LOGGER = Logger.getLogger(ExplorationPersistence.class.getName());
    private static final int DATA_VERSION = 1;
    private final Path storageDir;

    public ExplorationPersistence() {
        Path serverRoot = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        this.storageDir = serverRoot.resolve("mods").resolve("BetterMap").resolve("Data");
        LOGGER.info("Exploration storage root directory: " + this.storageDir.toString());
        try {
            if (!Files.exists(this.storageDir, new LinkOption[0])) {
                Files.createDirectories(this.storageDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LOGGER.severe("Failed to create exploration data directory: " + e.getMessage());
        }
    }

    public void load(@Nonnull Player player, @Nonnull String worldName) {
        UUID playerUUID = player.getUuid();
        if (playerUUID == null) {
            return;
        }
        Path worldDir = this.storageDir.resolve(worldName);
        Path file = worldDir.resolve(String.valueOf(playerUUID) + ".bin");
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])));){
            int version = in.readInt();
            if (version != 1) {
                LOGGER.warning("Unknown data version for player " + player.getDisplayName() + ": " + version);
            }
            int count = in.readInt();
            HashSet<Long> loadedChunks = new HashSet<Long>(count);
            for (int i = 0; i < count; ++i) {
                loadedChunks.add(in.readLong());
            }
            ExplorationTracker.PlayerExplorationData data = ExplorationTracker.getInstance().getOrCreatePlayerData(player);
            data.getExploredChunks().markChunksExplored(loadedChunks);
            Iterator iterator = loadedChunks.iterator();
            while (iterator.hasNext()) {
                long chunkIdx = (Long)iterator.next();
                int x = ChunkUtil.indexToChunkX(chunkIdx);
                int z = ChunkUtil.indexToChunkZ(chunkIdx);
                data.getMapExpansion().updateBoundaries(x, z, 0);
            }
            LOGGER.info("Loaded " + count + " explored chunks for " + player.getDisplayName() + " in world " + worldName);
        }
        catch (IOException e) {
            LOGGER.severe("Failed to load exploration data for " + player.getDisplayName() + ": " + e.getMessage());
        }
    }

    public void save(@Nonnull Player player) {
        UUIDComponent uuidComp;
        Ref ref = player.getReference();
        if (ref != null && ref.isValid() && (uuidComp = (UUIDComponent)ref.getStore().getComponent(ref, UUIDComponent.getComponentType())) != null && player.getWorld() != null) {
            this.save(player.getDisplayName(), uuidComp.getUuid(), player.getWorld().getName());
        }
    }

    public void saveAllPlayers() {
        Universe universe = Universe.get();
        if (universe == null) {
            return;
        }
        universe.getWorlds().values().forEach(world -> {
            try {
                world.execute(() -> {
                    LOGGER.info("Saving exploration data for world: " + world.getName());
                    world.getPlayerRefs().forEach(playerRef -> {
                        LOGGER.info(" - Saving player: " + String.valueOf(playerRef));
                        Player player = (Player)playerRef.getComponent(Player.getComponentType());
                        if (player != null) {
                            String playerName = player.getDisplayName();
                            UUID uuid = player.getUuid();
                            String worldName = world.getName();
                            ExplorationTracker.PlayerExplorationData data = ExplorationTracker.getInstance().getPlayerData(playerName);
                            if (data != null && uuid != null) {
                                Set<Long> chunks = data.getExploredChunks().getExploredChunks();
                                ForkJoinPool.commonPool().execute(() -> this.save(playerName, uuid, worldName, chunks));
                                LOGGER.info("Saved exploration data for player: " + playerName);
                            }
                        }
                    });
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void save(String playerName, UUID playerUUID, @Nonnull String worldName) {
        if (playerUUID == null) {
            LOGGER.warning("Cannot save data: Player UUID is null for " + playerName);
            return;
        }
        ExplorationTracker.PlayerExplorationData data = ExplorationTracker.getInstance().getPlayerData(playerName);
        if (data == null) {
            return;
        }
        this.save(playerName, playerUUID, worldName, data.getExploredChunks().getExploredChunks());
    }

    public void save(String playerName, UUID playerUUID, @Nonnull String worldName, Set<Long> chunks) {
        Path worldDir = this.storageDir.resolve(worldName);
        try {
            if (!Files.exists(worldDir, new LinkOption[0])) {
                Files.createDirectories(worldDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LOGGER.severe("Failed to create world exploration directory: " + e.getMessage());
            return;
        }
        Path file = worldDir.resolve(playerUUID.toString() + ".bin");
        LOGGER.info("[DEBUG] Saving " + chunks.size() + " chunks for " + playerName + " in world " + worldName);
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0])));){
            out.writeInt(1);
            out.writeInt(chunks.size());
            for (Long chunk : chunks) {
                out.writeLong(chunk);
            }
        }
        catch (IOException e) {
            LOGGER.severe("Failed to save exploration data for " + playerName + ": " + e.getMessage());
        }
    }

    public Set<Long> loadAllChunks(@Nonnull String worldName) {
        HashSet<Long> allChunks = new HashSet<Long>();
        Path worldDir = this.storageDir.resolve(worldName);
        if (!Files.exists(worldDir, new LinkOption[0])) {
            return allChunks;
        }
        try (Stream<Path> stream = Files.list(worldDir);){
            stream.filter(path -> path.toString().endsWith(".bin")).forEach(file -> {
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])));){
                    int version = in.readInt();
                    if (version == 1) {
                        int count = in.readInt();
                        for (int i = 0; i < count; ++i) {
                            allChunks.add(in.readLong());
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.warning("Failed to load chunk data from " + String.valueOf(file.getFileName()) + ": " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            LOGGER.severe("Failed to list files in " + String.valueOf(worldDir) + ": " + e.getMessage());
        }
        return allChunks;
    }
}

