/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BetterMapConfig {
    private static final Logger LOGGER = Logger.getLogger(BetterMapConfig.class.getName());
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static BetterMapConfig INSTANCE;
    private int explorationRadius = 16;
    private int updateRateMs = 500;
    private MapQuality mapQuality = MapQuality.MEDIUM;
    private float minScale = 10.0f;
    private float maxScale = 256.0f;
    private boolean debug = false;
    private boolean locationEnabled = false;
    private boolean shareAllExploration = false;
    private int maxChunksToLoad = 10000;
    private boolean radarEnabled = true;
    private int radarRange = -1;
    private boolean hidePlayersOnMap = false;
    private boolean hideOtherWarpsOnMap = false;
    private boolean hideUnexploredWarpsOnMap = true;
    private boolean allowWaypointTeleports = true;
    private boolean allowMapMarkerTeleports = true;
    private boolean hideAllPoiOnMap = false;
    private boolean hideUnexploredPoiOnMap = true;
    private List<String> hiddenPoiNames = new ArrayList<String>();
    private int autoSaveInterval = 5;
    private List<String> allowedWorlds = new ArrayList<String>(Arrays.asList("default", "world"));
    private transient Path configPath;
    private transient Path configDir;
    private transient MapQuality activeMapQuality;
    private transient int activeMaxChunksToLoad;

    public static synchronized BetterMapConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BetterMapConfig();
        }
        return INSTANCE;
    }

    public void initialize(Path rootPath) {
        this.configDir = rootPath.resolve("mods").resolve("BetterMap");
        this.configPath = this.configDir.resolve("config.json");
        try {
            if (!Files.exists(this.configDir, new LinkOption[0])) {
                Files.createDirectories(this.configDir, new FileAttribute[0]);
            }
            if (Files.exists(this.configPath, new LinkOption[0])) {
                this.load();
            } else {
                this.save();
            }
            this.activeMapQuality = this.mapQuality;
            this.activeMaxChunksToLoad = this.maxChunksToLoad;
        }
        catch (IOException e) {
            LOGGER.severe("Failed to initialize configuration: " + e.getMessage());
        }
    }

    public Path getConfigDirectory() {
        return this.configDir;
    }

    public void load() {
        try (BufferedReader reader = Files.newBufferedReader(this.configPath);){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            if (element.isJsonObject()) {
                JsonObject jsonObject = element.getAsJsonObject();
                BetterMapConfig loaded = (BetterMapConfig)GSON.fromJson(element, BetterMapConfig.class);
                boolean needsSave = false;
                if (loaded != null) {
                    this.explorationRadius = loaded.explorationRadius;
                    this.updateRateMs = loaded.updateRateMs;
                    if (jsonObject.has("minScale")) {
                        this.minScale = loaded.minScale;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("maxScale")) {
                        this.maxScale = loaded.maxScale;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("mapQuality")) {
                        this.mapQuality = loaded.mapQuality;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("debug")) {
                        this.debug = loaded.debug;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("locationEnabled")) {
                        this.locationEnabled = loaded.locationEnabled;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("shareAllExploration")) {
                        this.shareAllExploration = loaded.shareAllExploration;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("maxChunksToLoad")) {
                        this.maxChunksToLoad = loaded.maxChunksToLoad;
                    } else {
                        this.maxChunksToLoad = this.mapQuality.maxChunks;
                        needsSave = true;
                    }
                    if (this.maxChunksToLoad > this.mapQuality.maxChunks) {
                        this.maxChunksToLoad = this.mapQuality.maxChunks;
                        needsSave = true;
                        LOGGER.warning("maxChunksToLoad exceeded limit for " + String.valueOf((Object)this.mapQuality) + " quality. Clamped to " + this.maxChunksToLoad);
                    }
                    if (jsonObject.has("radarEnabled")) {
                        this.radarEnabled = loaded.radarEnabled;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("radarRange")) {
                        this.radarRange = loaded.radarRange;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("hidePlayersOnMap")) {
                        this.hidePlayersOnMap = loaded.hidePlayersOnMap;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("hideOtherWarpsOnMap")) {
                        this.hideOtherWarpsOnMap = loaded.hideOtherWarpsOnMap;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("hideUnexploredWarpsOnMap")) {
                        this.hideUnexploredWarpsOnMap = loaded.hideUnexploredWarpsOnMap;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("allowWaypointTeleports")) {
                        this.allowWaypointTeleports = loaded.allowWaypointTeleports;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("allowMapMarkerTeleports")) {
                        this.allowMapMarkerTeleports = loaded.allowMapMarkerTeleports;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("hideAllPoiOnMap")) {
                        this.hideAllPoiOnMap = loaded.hideAllPoiOnMap;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("hideUnexploredPoiOnMap")) {
                        this.hideUnexploredPoiOnMap = loaded.hideUnexploredPoiOnMap;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("hiddenPoiNames") && loaded.hiddenPoiNames != null) {
                        this.hiddenPoiNames = loaded.hiddenPoiNames;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("autoSaveInterval")) {
                        this.autoSaveInterval = loaded.autoSaveInterval;
                    } else {
                        needsSave = true;
                    }
                    if (jsonObject.has("allowedWorlds") && loaded.allowedWorlds != null) {
                        this.allowedWorlds = loaded.allowedWorlds;
                    } else {
                        needsSave = true;
                    }
                    if (needsSave) {
                        this.save();
                    }
                    this.updateLoggers();
                    LOGGER.info("Configuration loaded from " + String.valueOf(this.configPath));
                }
            }
        }
        catch (Exception e) {
            LOGGER.severe("Failed to load configuration: " + e.getMessage());
            this.mapQuality = MapQuality.MEDIUM;
            this.updateLoggers();
        }
    }

    private void updateLoggers() {
        Level level = this.debug ? Level.ALL : Level.OFF;
        this.setLoggerLevel("dev.ninesliced", level);
        this.setLoggerLevel("dev.ninesliced.commands", level);
        this.setLoggerLevel("dev.ninesliced.exploration", level);
        this.setLoggerLevel("dev.ninesliced.listeners.ExplorationEventListener", level);
        this.setLoggerLevel("dev.ninesliced.utils.WorldMapHook", level);
        this.setLoggerLevel("dev.ninesliced.configs.ExplorationPersistence", level);
        this.setLoggerLevel("dev.ninesliced.managers.PlayerConfigManager", level);
        this.setLoggerLevel("dev.ninesliced.managers.ExplorationManager", level);
        this.setLoggerLevel("dev.ninesliced.managers.WaypointManager", level);
        this.setLoggerLevel("dev.ninesliced.managers.MapPrivacyManager", level);
        this.setLoggerLevel("dev.ninesliced.managers.WarpPrivacyManager", level);
        this.setLoggerLevel("dev.ninesliced.managers.PoiPrivacyManager", level);
        this.setLoggerLevel("dev.ninesliced.managers.PlayerRadarManager", level);
        this.setLoggerLevel("dev.ninesliced.providers.LocationHudProvider", level);
        this.setLoggerLevel("dev.ninesliced.providers.WarpPrivacyProvider", level);
        this.setLoggerLevel("dev.ninesliced.providers.PoiPrivacyProvider", level);
        this.setLoggerLevel("dev.ninesliced.systems.LocationSystem", level);
        this.setLoggerLevel("dev.ninesliced.components.ExplorationComponent", level);
        this.setLoggerLevel("dev.ninesliced.exploration.ExplorationData", level);
        this.setLoggerLevel("dev.ninesliced.exploration.ExplorationPersistenceHandler", level);
        this.setLoggerLevel("dev.ninesliced.exploration.ExplorationSyncHandler", level);
        this.setLoggerLevel("dev.ninesliced.exploration.WaypointData", level);
        this.setLoggerLevel("dev.ninesliced.exploration.RadarSystem", level);
    }

    private void setLoggerLevel(String loggerName, Level level) {
        Logger logger = Logger.getLogger(loggerName);
        logger.setLevel(level);
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)writer);
            LOGGER.info("Configuration saved to " + String.valueOf(this.configPath));
        }
        catch (IOException e) {
            LOGGER.severe("Failed to save configuration: " + e.getMessage());
        }
    }

    public void reload() {
        if (this.configPath != null && Files.exists(this.configPath, new LinkOption[0])) {
            this.load();
        }
    }

    public int getExplorationRadius() {
        return this.explorationRadius;
    }

    public int getUpdateRateMs() {
        return this.updateRateMs;
    }

    public MapQuality getMapQuality() {
        return this.mapQuality;
    }

    public MapQuality getActiveMapQuality() {
        return this.activeMapQuality != null ? this.activeMapQuality : this.mapQuality;
    }

    public int getActiveMaxChunksToLoad() {
        return this.activeMaxChunksToLoad > 0 ? this.activeMaxChunksToLoad : this.maxChunksToLoad;
    }

    public float getMinScale() {
        return this.minScale;
    }

    public void setMinScale(float minScale) {
        this.minScale = minScale;
        this.save();
    }

    public int getAutoSaveInterval() {
        return this.autoSaveInterval;
    }

    public void setAutoSaveInterval(int autoSaveInterval) {
        this.autoSaveInterval = autoSaveInterval;
        this.save();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.updateLoggers();
        this.save();
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(float maxScale) {
        this.maxScale = maxScale;
        this.save();
    }

    public void setExplorationRadius(int explorationRadius) {
        this.explorationRadius = explorationRadius;
        this.save();
    }

    public void setQuality(MapQuality mapQuality) {
        this.mapQuality = mapQuality;
        this.maxChunksToLoad = mapQuality.maxChunks;
        this.save();
    }

    public boolean isLocationEnabled() {
        return this.locationEnabled;
    }

    public boolean isShareAllExploration() {
        return this.shareAllExploration;
    }

    public void setShareAllExploration(boolean shareAllExploration) {
        this.shareAllExploration = shareAllExploration;
        this.save();
    }

    public MapQuality getActiveMapQualitySetting() {
        return this.activeMapQuality;
    }

    public void setLocationEnabled(boolean locationEnabled) {
        this.locationEnabled = locationEnabled;
    }

    public int getMaxChunksToLoad() {
        return this.maxChunksToLoad;
    }

    public void setMaxChunksToLoad(int maxChunksToLoad) {
        this.maxChunksToLoad = maxChunksToLoad;
        this.save();
    }

    public boolean isRadarEnabled() {
        return this.radarEnabled;
    }

    public int getRadarRange() {
        return this.radarRange;
    }

    public boolean isHidePlayersOnMap() {
        return this.hidePlayersOnMap;
    }

    public boolean isHideOtherWarpsOnMap() {
        return this.hideOtherWarpsOnMap;
    }

    public boolean isHideUnexploredWarpsOnMap() {
        return this.hideUnexploredWarpsOnMap;
    }

    public boolean isAllowWaypointTeleports() {
        return this.allowWaypointTeleports;
    }

    public boolean isAllowMapMarkerTeleports() {
        return this.allowMapMarkerTeleports;
    }

    public boolean isHideAllPoiOnMap() {
        return this.hideAllPoiOnMap;
    }

    public boolean isHideUnexploredPoiOnMap() {
        return this.hideUnexploredPoiOnMap;
    }

    public List<String> getHiddenPoiNames() {
        return this.hiddenPoiNames;
    }

    public void setHidePlayersOnMap(boolean hidePlayersOnMap) {
        this.hidePlayersOnMap = hidePlayersOnMap;
        this.save();
    }

    public void setHideOtherWarpsOnMap(boolean hideOtherWarpsOnMap) {
        this.hideOtherWarpsOnMap = hideOtherWarpsOnMap;
        this.save();
    }

    public void setHideUnexploredWarpsOnMap(boolean hideUnexploredWarpsOnMap) {
        this.hideUnexploredWarpsOnMap = hideUnexploredWarpsOnMap;
        this.save();
    }

    public void setAllowWaypointTeleports(boolean allowWaypointTeleports) {
        this.allowWaypointTeleports = allowWaypointTeleports;
        this.save();
    }

    public void setAllowMapMarkerTeleports(boolean allowMapMarkerTeleports) {
        this.allowMapMarkerTeleports = allowMapMarkerTeleports;
        this.save();
    }

    public void setHideAllPoiOnMap(boolean hideAllPoiOnMap) {
        this.hideAllPoiOnMap = hideAllPoiOnMap;
        this.save();
    }

    public void setHideUnexploredPoiOnMap(boolean hideUnexploredPoiOnMap) {
        this.hideUnexploredPoiOnMap = hideUnexploredPoiOnMap;
        this.save();
    }

    public void setHiddenPoiNames(List<String> hiddenPoiNames) {
        this.hiddenPoiNames = hiddenPoiNames != null ? hiddenPoiNames : new ArrayList();
        this.save();
    }

    public void setRadarEnabled(boolean radarEnabled) {
        this.radarEnabled = radarEnabled;
        this.save();
    }

    public void setRadarRange(int radarRange) {
        this.radarRange = radarRange;
        this.save();
    }

    public List<String> getAllowedWorlds() {
        return this.allowedWorlds;
    }

    public boolean isTrackedWorld(String worldName) {
        return this.allowedWorlds != null && this.allowedWorlds.contains(worldName);
    }

    public void setAllowedWorlds(List<String> allowedWorlds) {
        this.allowedWorlds = allowedWorlds;
        this.save();
    }

    public boolean addAllowedWorld(String worldName) {
        if (this.allowedWorlds == null) {
            this.allowedWorlds = new ArrayList<String>();
        }
        if (!this.allowedWorlds.contains(worldName)) {
            this.allowedWorlds.add(worldName);
            this.save();
            return true;
        }
        return false;
    }

    public boolean removeAllowedWorld(String worldName) {
        if (this.allowedWorlds != null && this.allowedWorlds.contains(worldName)) {
            this.allowedWorlds.remove(worldName);
            this.save();
            return true;
        }
        return false;
    }

    public static enum MapQuality {
        LOW(0.25f, 30000),
        MEDIUM(0.5f, 10000),
        HIGH(1.0f, 3000);

        public final float scale;
        public final int maxChunks;

        private MapQuality(float scale, int maxChunks) {
            this.scale = scale;
            this.maxChunks = maxChunks;
        }
    }
}

