/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.components;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.codec.codecs.array.LongArrayCodec;
import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import javax.annotation.Nonnull;

public class ExplorationComponent
implements Component<EntityStore> {
    public static final BuilderCodec<ExplorationComponent> CODEC = ((BuilderCodec.Builder)BuilderCodec.builder(ExplorationComponent.class, ExplorationComponent::new).append(new KeyedCodec("ExploredChunks", (Codec)new LongArrayCodec()), (component, chunks) -> {
        component.exploredChunks = chunks != null ? new LongOpenHashSet(chunks) : new LongOpenHashSet();
    }, component -> component.exploredChunks.toLongArray()).add()).build();
    private LongSet exploredChunks = new LongOpenHashSet();

    public LongSet getExploredChunks() {
        return this.exploredChunks;
    }

    public void addExploredChunk(long chunkIndex) {
        this.exploredChunks.add(chunkIndex);
    }

    public boolean isExplored(long chunkIndex) {
        return this.exploredChunks.contains(chunkIndex);
    }

    @Nonnull
    public Component<EntityStore> clone() {
        ExplorationComponent clone = new ExplorationComponent();
        clone.exploredChunks = new LongOpenHashSet((LongCollection)this.exploredChunks);
        return clone;
    }
}

