/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands.config;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.entity.entities.Player;
import dev.ninesliced.configs.BetterMapConfig;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UntrackWorldCommand
extends AbstractCommand {
    private final OptionalArg<String> worldArg = this.withOptionalArg("world", "World name to untrack", (ArgumentType)ArgTypes.STRING);

    public UntrackWorldCommand() {
        super("untrack", "Remove a world from the exploration tracking list");
        this.requirePermission("dev.ninesliced.bettermap.command.config");
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        boolean removed;
        String worldName = (String)context.get(this.worldArg);
        if (worldName == null || worldName.isEmpty()) {
            if (!context.isPlayer()) {
                context.sendMessage(Message.raw((String)"You must specify a world name when running from console.").color(Color.RED));
                return CompletableFuture.completedFuture(null);
            }
            CommandSender sender = context.sender();
            if (!(sender instanceof Player)) {
                context.sendMessage(Message.raw((String)"This command must be run by a player or specify a world name.").color(Color.RED));
                return CompletableFuture.completedFuture(null);
            }
            assert (((Player)sender).getWorld() != null);
            worldName = ((Player)sender).getWorld().getName();
        }
        if (removed = BetterMapConfig.getInstance().removeAllowedWorld(worldName)) {
            context.sendMessage(Message.raw((String)("World '" + worldName + "' removed from tracked worlds.")).color(Color.GREEN));
            context.sendMessage(Message.raw((String)"Changes saved to config.").color(Color.GRAY));
            return CompletableFuture.completedFuture(null);
        }
        context.sendMessage(Message.raw((String)("World '" + worldName + "' is not currently tracked.")).color(Color.YELLOW));
        return CompletableFuture.completedFuture(null);
    }
}

