/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands.config;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.universe.Universe;
import dev.ninesliced.configs.BetterMapConfig;
import dev.ninesliced.utils.WorldMapHook;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class ShareAllExplorationCommand
extends AbstractCommand {
    public ShareAllExplorationCommand() {
        super("shareallexploration", "Toggle sharing of all exploration data");
        this.requirePermission("dev.ninesliced.bettermap.command.config");
        this.addAliases(new String[]{"shareall"});
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    public CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        BetterMapConfig config = BetterMapConfig.getInstance();
        BetterMapConfig.getInstance().setShareAllExploration(!config.isShareAllExploration());
        context.sendMessage(Message.raw((String)("ShareAllExploration set to: " + config.isShareAllExploration())).color(Color.GREEN));
        Universe universe = Universe.get();
        if (universe != null) {
            universe.getWorlds().values().forEach(WorldMapHook::refreshTrackers);
        }
        return CompletableFuture.completedFuture(null);
    }
}

