/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands.config;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.ninesliced.configs.BetterMapConfig;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class RadarToggleCommand
extends AbstractCommand {
    public RadarToggleCommand() {
        super("radar", "Toggle player radar visibility on the map");
        this.requirePermission("dev.ninesliced.bettermap.command.config");
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    @NullableDecl
    protected CompletableFuture<Void> execute(@NonNullDecl CommandContext commandContext) {
        if (!commandContext.isPlayer()) {
            return CompletableFuture.completedFuture(null);
        }
        Ref ref = commandContext.senderAsPlayerRef();
        if (ref == null) {
            return CompletableFuture.completedFuture(null);
        }
        Store store = ref.getStore();
        World world = ((EntityStore)store.getExternalData()).getWorld();
        return CompletableFuture.runAsync(() -> {
            Player playerComponent = (Player)store.getComponent(ref, Player.getComponentType());
            PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
            if (playerComponent == null || playerRef == null) {
                return;
            }
            BetterMapConfig config = BetterMapConfig.getInstance();
            boolean newState = !config.isRadarEnabled();
            config.setRadarEnabled(newState);
            String status = newState ? "ENABLED" : "DISABLED";
            Color color = newState ? Color.GREEN : Color.RED;
            playerRef.sendMessage(Message.raw((String)("Player Radar " + status)).color(color));
            if (newState) {
                String rangeText = config.getRadarRange() < 0 ? "Infinite" : config.getRadarRange() + " blocks";
                playerRef.sendMessage(Message.raw((String)("Range: " + rangeText)).color(Color.GRAY));
            }
        }, (Executor)world);
    }
}

