/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands.config;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.ninesliced.configs.BetterMapConfig;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class RadarRangeCommand
extends AbstractCommand {
    private final RequiredArg<Integer> rangeArg = this.withRequiredArg("range", "The range in blocks (-1 for infinite)", (ArgumentType)ArgTypes.INTEGER);

    public RadarRangeCommand() {
        super("radarrange", "Set player radar range (usage: /bm radarrange <number|-1>)");
        this.requirePermission("dev.ninesliced.bettermap.command.config");
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    @NullableDecl
    protected CompletableFuture<Void> execute(@NonNullDecl CommandContext commandContext) {
        if (!commandContext.isPlayer()) {
            return CompletableFuture.completedFuture(null);
        }
        Ref ref = commandContext.senderAsPlayerRef();
        if (ref == null) {
            return CompletableFuture.completedFuture(null);
        }
        Store store = ref.getStore();
        World world = ((EntityStore)store.getExternalData()).getWorld();
        Integer rangeValue = (Integer)commandContext.get(this.rangeArg);
        return CompletableFuture.runAsync(() -> {
            Player playerComponent = (Player)store.getComponent(ref, Player.getComponentType());
            PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
            if (playerComponent == null || playerRef == null) {
                return;
            }
            BetterMapConfig config = BetterMapConfig.getInstance();
            this.setNewRange(playerRef, config, rangeValue);
        }, (Executor)world);
    }

    private void setNewRange(PlayerRef playerRef, BetterMapConfig config, int rangeValue) {
        if (rangeValue < 0) {
            config.setRadarRange(-1);
            playerRef.sendMessage(Message.raw((String)"Radar range set to Infinite").color(Color.GREEN));
            return;
        }
        config.setRadarRange(rangeValue);
        playerRef.sendMessage(Message.raw((String)("Radar range set to " + rangeValue + " blocks")).color(Color.GREEN));
    }
}

