/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands.config;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import dev.ninesliced.configs.BetterMapConfig;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MaxChunksToLoadCommand
extends AbstractCommand {
    private final RequiredArg<Integer> chunksArg = this.withRequiredArg("value", "Max chunks to load", (ArgumentType)ArgTypes.INTEGER);

    public MaxChunksToLoadCommand() {
        super("maxchunks", "Set max chunks to load (limit depends on quality)");
        this.requirePermission("dev.ninesliced.bettermap.command.config");
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    @Nullable
    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        BetterMapConfig config = BetterMapConfig.getInstance();
        Integer requestedChunks = (Integer)context.get(this.chunksArg);
        if (requestedChunks == null) {
            context.sendMessage(Message.raw((String)"Please specify a value.").color(Color.RED));
            return CompletableFuture.completedFuture(null);
        }
        BetterMapConfig.MapQuality currentQuality = config.getMapQuality();
        int limit = currentQuality.maxChunks;
        if (requestedChunks > limit) {
            config.setMaxChunksToLoad(limit);
            context.sendMessage(Message.raw((String)("Requested " + requestedChunks + " exceeds limit for " + currentQuality.name() + " quality (" + limit + ").")).color(Color.YELLOW));
            context.sendMessage(Message.raw((String)("Set max chunks to " + limit + ".")).color(Color.YELLOW));
        } else {
            config.setMaxChunksToLoad(requestedChunks);
            context.sendMessage(Message.raw((String)("Set max chunks to " + requestedChunks + ".")).color(Color.GREEN));
        }
        context.sendMessage(Message.raw((String)"NOTE: The server must be restarted for this change to take effect.").color(Color.GRAY));
        return CompletableFuture.completedFuture(null);
    }
}

