/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands.config;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import dev.ninesliced.configs.BetterMapConfig;
import java.awt.Color;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class MapQualityCommand
extends AbstractCommand {
    private final RequiredArg<String> qualityValueArg = this.withRequiredArg("value", "Quality map value", (ArgumentType)ArgTypes.STRING);

    protected MapQualityCommand() {
        super("quality", "Set the map quality (low, medium, high)");
        this.requirePermission("dev.ninesliced.bettermap.command.config");
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    @NullableDecl
    protected CompletableFuture<Void> execute(@NonNullDecl CommandContext context) {
        BetterMapConfig.MapQuality mapQuality;
        String quality = (String)context.get(this.qualityValueArg);
        try {
            mapQuality = BetterMapConfig.MapQuality.valueOf(quality.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException exception) {
            context.sendMessage(Message.raw((String)("Invalid quality value: " + quality)).color(Color.RED));
            return CompletableFuture.completedFuture(null);
        }
        BetterMapConfig.getInstance().setQuality(mapQuality);
        context.sendMessage(Message.raw((String)("Map quality set to: " + mapQuality.name())).color(Color.GREEN));
        context.sendMessage(Message.raw((String)("WARNING: Map Quality change pending restart (Active: " + BetterMapConfig.getInstance().getActiveMapQuality().name() + ")")).color(Color.RED));
        return CompletableFuture.completedFuture(null);
    }
}

