/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands.config;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import dev.ninesliced.configs.BetterMapConfig;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MapMinScaleCommand
extends AbstractCommand {
    private final RequiredArg<Float> zoomValueArg = this.withRequiredArg("value", "Min zoom value", (ArgumentType)ArgTypes.FLOAT);

    public MapMinScaleCommand() {
        super("minscale", "Set min map zoom scale (lower = zoom out further)");
        this.requirePermission("dev.ninesliced.bettermap.command.config");
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    @Nullable
    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        return CompletableFuture.runAsync(() -> {
            if (!context.isPlayer()) {
                context.sendMessage(Message.raw((String)"This command must be run by a player").color(Color.RED));
                return;
            }
            Float newMin = (Float)context.get(this.zoomValueArg);
            if (newMin.floatValue() < 2.0f) {
                context.sendMessage(Message.raw((String)"Min scale must be greater or equals to 2").color(Color.RED));
                return;
            }
            BetterMapConfig config = BetterMapConfig.getInstance();
            if (newMin.floatValue() >= config.getMaxScale()) {
                context.sendMessage(Message.raw((String)("Min scale must be less than max scale (" + config.getMaxScale() + ")")).color(Color.RED));
                return;
            }
            config.setMinScale(newMin.floatValue());
            context.sendMessage(Message.raw((String)"Map min scale set to: ").color(Color.GREEN).insert(Message.raw((String)String.valueOf(newMin)).color(Color.YELLOW)));
        });
    }
}

