/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands.config;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import dev.ninesliced.configs.BetterMapConfig;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MapMaxScaleCommand
extends AbstractCommand {
    private final RequiredArg<Float> zoomValueArg = this.withRequiredArg("value", "Max zoom value", (ArgumentType)ArgTypes.FLOAT);

    public MapMaxScaleCommand() {
        super("maxscale", "Set max map zoom scale (higher = zoom in closer)");
        this.requirePermission("dev.ninesliced.bettermap.command.config");
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    @Nullable
    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        return CompletableFuture.runAsync(() -> {
            if (!context.isPlayer()) {
                context.sendMessage(Message.raw((String)"This command must be run by a player").color(Color.RED));
                return;
            }
            Float newMax = (Float)context.get(this.zoomValueArg);
            if (newMax.floatValue() <= 0.0f) {
                context.sendMessage(Message.raw((String)"Max scale must be greater than 0").color(Color.RED));
                return;
            }
            BetterMapConfig config = BetterMapConfig.getInstance();
            if (newMax.floatValue() <= config.getMinScale()) {
                context.sendMessage(Message.raw((String)("Max scale must be greater than min scale (" + config.getMinScale() + ")")).color(Color.RED));
                return;
            }
            config.setMaxScale(newMax.floatValue());
            context.sendMessage(Message.raw((String)"Map max scale set to: ").color(Color.GREEN).insert(Message.raw((String)String.valueOf(newMax)).color(Color.YELLOW)));
        });
    }
}

