/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands.config;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import dev.ninesliced.configs.BetterMapConfig;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MapExplorationRadiusCommand
extends AbstractCommand {
    private final RequiredArg<Integer> radiusArg = this.withRequiredArg("radius", "Exploration radius in chunks", (ArgumentType)ArgTypes.INTEGER);

    public MapExplorationRadiusCommand() {
        super("radius", "Set exploration radius in chunks");
        this.requirePermission("dev.ninesliced.bettermap.command.config");
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    @Nullable
    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        try {
            Integer newRadius = (Integer)context.get(this.radiusArg);
            if (newRadius <= 0) {
                context.sendMessage(Message.raw((String)"Radius must be greater than 0").color(Color.RED));
                return CompletableFuture.completedFuture(null);
            }
            BetterMapConfig config = BetterMapConfig.getInstance();
            config.setExplorationRadius(newRadius);
            context.sendMessage(Message.raw((String)"Exploration radius set to: ").color(Color.GREEN).insert(Message.raw((String)String.valueOf(newRadius)).color(Color.YELLOW)));
            context.sendMessage(Message.raw((String)"NOTE: Updates will apply as players move to new chunks.").color(Color.YELLOW));
        }
        catch (Exception e) {
            context.sendMessage(Message.raw((String)("Error: " + e.getMessage())).color(Color.RED));
            e.printStackTrace();
        }
        return CompletableFuture.completedFuture(null);
    }
}

