/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands.config;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.ninesliced.configs.BetterMapConfig;
import dev.ninesliced.managers.MapPrivacyManager;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class HidePlayersCommand
extends AbstractCommand {
    public HidePlayersCommand() {
        super("hideplayers", "Toggle global map privacy (Hides players from map)");
        this.requirePermission("dev.ninesliced.bettermap.command.config");
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    @NullableDecl
    protected CompletableFuture<Void> execute(@NonNullDecl CommandContext commandContext) {
        if (!commandContext.isPlayer()) {
            commandContext.sendMessage(Message.raw((String)"This command can only be used by a player.").color(Color.RED));
            return CompletableFuture.completedFuture(null);
        }
        Ref ref = commandContext.senderAsPlayerRef();
        if (ref == null) {
            return CompletableFuture.completedFuture(null);
        }
        Store store = ref.getStore();
        World world = ((EntityStore)store.getExternalData()).getWorld();
        return CompletableFuture.runAsync(() -> {
            Player playerComponent = (Player)store.getComponent(ref, Player.getComponentType());
            PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
            if (playerComponent == null || playerRef == null) {
                return;
            }
            BetterMapConfig config = BetterMapConfig.getInstance();
            boolean newState = !config.isHidePlayersOnMap();
            config.setHidePlayersOnMap(newState);
            MapPrivacyManager.getInstance().updatePrivacyState();
            String status = newState ? "ENABLED" : "DISABLED";
            Color color = newState ? Color.GREEN : Color.RED;
            playerRef.sendMessage(Message.raw((String)("Global Map Privacy " + status)).color(color));
            if (newState) {
                playerRef.sendMessage(Message.raw((String)"Players are now hidden from the world map.").color(Color.GRAY));
            } else {
                playerRef.sendMessage(Message.raw((String)"Players are now visible on the world map.").color(Color.GRAY));
            }
        }, (Executor)world);
    }
}

