/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands.config;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import dev.ninesliced.configs.BetterMapConfig;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DebugCommand
extends AbstractCommand {
    private final RequiredArg<Boolean> debugValueArg = this.withRequiredArg("value", "Enable/Disable debug logs", (ArgumentType)ArgTypes.BOOLEAN);

    public DebugCommand() {
        super("debug", "Toggle debug logging");
        this.requirePermission("dev.ninesliced.bettermap.command.config");
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    @Nullable
    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        try {
            Boolean newDebug = (Boolean)context.get(this.debugValueArg);
            BetterMapConfig config = BetterMapConfig.getInstance();
            config.setDebug(newDebug);
            context.sendMessage(Message.raw((String)("BetterMap debug mode set to: " + newDebug)).color(Color.GREEN));
        }
        catch (Exception e) {
            context.sendMessage(Message.raw((String)("Error setting debug mode: " + e.getMessage())).color(Color.RED));
        }
        return CompletableFuture.completedFuture(null);
    }
}

