/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands.config;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import dev.ninesliced.configs.BetterMapConfig;
import dev.ninesliced.managers.ExplorationManager;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AutoSaveIntervalCommand
extends AbstractCommand {
    private final OptionalArg<Integer> intervalArg = this.withOptionalArg("interval", "Auto-save interval in minutes", (ArgumentType)ArgTypes.INTEGER);

    public AutoSaveIntervalCommand() {
        super("autosave", "Get or set the exploration auto-save interval");
        this.requirePermission("dev.ninesliced.bettermap.command.config");
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    @Nullable
    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        Integer interval = (Integer)context.get(this.intervalArg);
        if (interval == null) {
            int current = BetterMapConfig.getInstance().getAutoSaveInterval();
            context.sendMessage(Message.raw((String)("Current auto-save interval: " + current + " minutes.")).color(Color.YELLOW));
        } else {
            if (interval < 0) {
                context.sendMessage(Message.raw((String)"Interval cannot be negative.").color(Color.RED));
                return CompletableFuture.completedFuture(null);
            }
            BetterMapConfig.getInstance().setAutoSaveInterval(interval);
            ExplorationManager.getInstance().startAutoSave();
            context.sendMessage(Message.raw((String)("Auto-save interval set to " + interval + " minutes.")).color(Color.GREEN));
            if (interval == 0) {
                context.sendMessage(Message.raw((String)"Auto-save is now DISABLED.").color(Color.YELLOW));
            }
        }
        return CompletableFuture.completedFuture(null);
    }
}

