/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.universe.Universe;
import dev.ninesliced.configs.BetterMapConfig;
import dev.ninesliced.managers.MapPrivacyManager;
import dev.ninesliced.managers.PoiPrivacyManager;
import dev.ninesliced.managers.WarpPrivacyManager;
import dev.ninesliced.utils.WorldMapHook;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class ReloadCommand
extends AbstractCommand {
    protected ReloadCommand() {
        super("reload", "Reload BetterMap configuration");
        this.requirePermission("dev.ninesliced.bettermap.command.reload");
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    protected String generatePermissionNode() {
        return "reload";
    }

    @NullableDecl
    protected CompletableFuture<Void> execute(@NonNullDecl CommandContext context) {
        BetterMapConfig.getInstance().reload();
        MapPrivacyManager.getInstance().updatePrivacyState();
        WarpPrivacyManager.getInstance().updatePrivacyState();
        PoiPrivacyManager.getInstance().updatePrivacyState();
        Universe universe = Universe.get();
        if (universe != null) {
            universe.getWorlds().values().forEach(world -> world.execute(() -> {
                WorldMapHook.updateWorldMapConfigs(world);
                WorldMapHook.broadcastMapSettings(world);
                WorldMapHook.refreshTrackers(world);
            }));
        }
        context.sendMessage(Message.raw((String)"BetterMap configuration reloaded!").color(Color.GREEN));
        context.sendMessage(Message.raw((String)"Exploration Radius: ").color(Color.YELLOW).insert(Message.raw((String)String.valueOf(BetterMapConfig.getInstance().getExplorationRadius())).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Min Scale: ").color(Color.YELLOW).insert(Message.raw((String)String.valueOf(BetterMapConfig.getInstance().getMinScale())).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Max Scale: ").color(Color.YELLOW).insert(Message.raw((String)String.valueOf(BetterMapConfig.getInstance().getMaxScale())).color(Color.WHITE)));
        BetterMapConfig config = BetterMapConfig.getInstance();
        context.sendMessage(Message.raw((String)"Map Quality: ").color(Color.YELLOW).insert(Message.raw((String)config.getMapQuality().name()).color(Color.WHITE)));
        if (config.getMapQuality() != config.getActiveMapQuality()) {
            context.sendMessage(Message.raw((String)("WARNING: Map Quality change pending restart (Active: " + config.getActiveMapQuality().name() + ")")).color(Color.RED));
        }
        context.sendMessage(Message.raw((String)"NOTE: The server must be restarted for map quality/max chunks changes to take effect."));
        return CompletableFuture.completedFuture(null);
    }
}

