/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.ninesliced.configs.PlayerConfig;
import dev.ninesliced.managers.PlayerConfigManager;
import dev.ninesliced.utils.WorldMapHook;
import java.awt.Color;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PlayerMaxScaleCommand
extends AbstractCommand {
    private final RequiredArg<Float> scaleArg = this.withRequiredArg("scale", "Max scale value", (ArgumentType)ArgTypes.FLOAT);

    public PlayerMaxScaleCommand() {
        super("maxscale", "Set player max map scale");
    }

    protected String generatePermissionNode() {
        return "maxscale";
    }

    @Nullable
    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        if (!context.isPlayer()) {
            context.sendMessage(Message.raw((String)"This command must be run by a player").color(Color.RED));
            return CompletableFuture.completedFuture(null);
        }
        try {
            Float scale = (Float)context.get(this.scaleArg);
            if (scale.floatValue() <= 0.0f) {
                context.sendMessage(Message.raw((String)"Scale must be greater than 0").color(Color.RED));
                return CompletableFuture.completedFuture(null);
            }
            UUID uuid = context.sender().getUuid();
            Player player = (Player)context.sender();
            World world = player.getWorld();
            PlayerConfig config = PlayerConfigManager.getInstance().getPlayerConfig(uuid);
            if (world == null) {
                context.sendMessage(Message.raw((String)"Could not access world").color(Color.RED));
                return CompletableFuture.completedFuture(null);
            }
            if (config != null) {
                config.setMaxScale(scale.floatValue());
                PlayerConfigManager.getInstance().savePlayerConfig(uuid);
                world.execute(() -> WorldMapHook.sendMapSettingsToPlayer(player));
                context.sendMessage(Message.raw((String)("Set player max scale to " + scale)).color(Color.GREEN));
            } else {
                context.sendMessage(Message.raw((String)"Could not load player config.").color(Color.RED));
            }
        }
        catch (Exception e) {
            context.sendMessage(Message.raw((String)("Error setting max scale: " + e.getMessage())).color(Color.RED));
            e.printStackTrace();
        }
        return CompletableFuture.completedFuture(null);
    }
}

