/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.protocol.packets.worldmap.MapMarker;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.ninesliced.managers.WaypointManager;
import javax.annotation.Nonnull;

public class BetterMapWaypointUpdateCommand
extends AbstractPlayerCommand {
    private final RequiredArg<String> targetArg = this.withRequiredArg("target", "Waypoint name or marker id", (ArgumentType)ArgTypes.STRING);
    private final OptionalArg<String> newNameArg = this.withOptionalArg("newName", "New name for the waypoint", (ArgumentType)ArgTypes.STRING);
    private final OptionalArg<String> colorArg = this.withOptionalArg("color", "Color name (red/green/blue/etc)", (ArgumentType)ArgTypes.STRING);

    public BetterMapWaypointUpdateCommand() {
        super("update", "Update a map waypoint");
        this.addAliases(new String[]{"edit"});
        this.setPermissionGroup(GameMode.Adventure);
        this.setPermissionGroup(GameMode.Creative);
    }

    protected void execute(@Nonnull CommandContext context, @Nonnull Store<EntityStore> store, @Nonnull Ref<EntityStore> ref, @Nonnull PlayerRef playerRef, @Nonnull World world) {
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player == null) {
            return;
        }
        String target = (String)this.targetArg.get(context);
        String newNameRaw = (String)this.newNameArg.get(context);
        String newColorInput = (String)this.colorArg.get(context);
        if (newNameRaw == null && newColorInput == null) {
            context.sendMessage(Message.raw((String)"You must provide either a name or a color to update."));
            return;
        }
        MapMarker marker = WaypointManager.findWaypoint(player, target);
        if (marker != null) {
            String icon = null;
            if (newColorInput != null && !newColorInput.isEmpty()) {
                String normalized = newColorInput.trim().toLowerCase();
                String capitalized = Character.toUpperCase(normalized.charAt(0)) + normalized.substring(1);
                icon = capitalized + "Marker.png";
            }
            WaypointManager.updateWaypoint(player, marker.id, newNameRaw, icon, null);
            context.sendMessage(Message.raw((String)("Updated waypoint: " + (marker.name != null ? marker.name : target))));
        } else {
            context.sendMessage(Message.raw((String)"Could not find waypoint with that name or id."));
        }
    }
}

