/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.protocol.packets.worldmap.MapMarker;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.data.PlayerWorldData;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import javax.annotation.Nonnull;

public class BetterMapWaypointIdCommand
extends AbstractPlayerCommand {
    private final RequiredArg<String> nameArg = this.withRequiredArg("name", "Waypoint name", (ArgumentType)ArgTypes.STRING);

    public BetterMapWaypointIdCommand() {
        super("id", "Get the marker id for a waypoint by name");
        this.setPermissionGroup(GameMode.Adventure);
        this.setPermissionGroup(GameMode.Creative);
    }

    protected void execute(@Nonnull CommandContext context, @Nonnull Store<EntityStore> store, @Nonnull Ref<EntityStore> ref, @Nonnull PlayerRef playerRef, @Nonnull World world) {
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player == null) {
            return;
        }
        String targetName = (String)this.nameArg.get(context);
        PlayerWorldData perWorldData = player.getPlayerConfigData().getPerWorldData(world.getName());
        MapMarker[] markers = perWorldData.getWorldMapMarkers();
        if (markers == null || markers.length == 0) {
            context.sendMessage(Message.raw((String)"You have no waypoints."));
            return;
        }
        for (MapMarker marker : markers) {
            if (marker == null || marker.name == null || !marker.name.equalsIgnoreCase(targetName)) continue;
            context.sendMessage(Message.raw((String)("Waypoint '" + targetName + "' id: " + marker.id)));
            return;
        }
        context.sendMessage(Message.raw((String)("Waypoint not found: " + targetName)));
    }
}

