/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.worldmap.MapMarker;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.ninesliced.managers.WaypointManager;
import dev.ninesliced.utils.PermissionsUtil;
import javax.annotation.Nonnull;

public class BetterMapWaypointDeleteGlobalCommand
extends AbstractPlayerCommand {
    private final RequiredArg<String> targetArg = this.withRequiredArg("target", "Global waypoint id", (ArgumentType)ArgTypes.STRING);

    protected String generatePermissionNode() {
        return "waypoint.global";
    }

    protected boolean canGeneratePermission() {
        return true;
    }

    public BetterMapWaypointDeleteGlobalCommand() {
        super("removeglobal", "Remove a global map waypoint");
        this.addAliases(new String[]{"deleteglobal", "delglobal"});
    }

    protected void execute(@Nonnull CommandContext context, @Nonnull Store<EntityStore> store, @Nonnull Ref<EntityStore> ref, @Nonnull PlayerRef playerRef, @Nonnull World world) {
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player == null) {
            return;
        }
        if (!PermissionsUtil.canUseGlobalWaypoints(player)) {
            context.sendMessage(Message.raw((String)"You do not have permission to delete global waypoints."));
            return;
        }
        String target = (String)this.targetArg.get(context);
        MapMarker marker = WaypointManager.findWaypoint(player, target);
        if (marker == null) {
            if (!WaypointManager.isGlobalId(target)) {
                context.sendMessage(Message.raw((String)"Could not find global waypoint with that name or id."));
                return;
            }
            boolean deletedFallback = WaypointManager.removeWaypoint(player, target);
            if (deletedFallback) {
                context.sendMessage(Message.raw((String)"Global waypoint has been removed."));
            } else {
                context.sendMessage(Message.raw((String)"Could not find global waypoint with that name or id."));
            }
            return;
        }
        if (!WaypointManager.isGlobalId(marker.id)) {
            context.sendMessage(Message.raw((String)"That is a personal waypoint. Use 'remove' instead of 'removeglobal'."));
            return;
        }
        boolean deleted = WaypointManager.removeWaypoint(player, marker.id);
        if (deleted) {
            context.sendMessage(Message.raw((String)("Global waypoint '" + marker.name + "' has been removed.")));
        } else {
            context.sendMessage(Message.raw((String)"Failed to remove global waypoint."));
        }
    }
}

