/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.protocol.Transform;
import com.hypixel.hytale.protocol.packets.worldmap.MapMarker;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.data.PlayerWorldData;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.PositionUtil;
import dev.ninesliced.managers.WaypointManager;
import dev.ninesliced.utils.PermissionsUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class BetterMapWaypointAddCommand
extends AbstractPlayerCommand {
    private final OptionalArg<String> nameArg = this.withOptionalArg("name", "Name of the waypoint", (ArgumentType)ArgTypes.STRING);
    private final OptionalArg<String> colorArg = this.withOptionalArg("color", "Color name (red/green/blue)", (ArgumentType)ArgTypes.STRING);
    private final OptionalArg<Boolean> globalArg = this.withOptionalArg("global", "Save as global waypoint (requires permission)", (ArgumentType)ArgTypes.BOOLEAN);
    private static final Pattern AUTO_NAME_PATTERN = Pattern.compile("Waypoint_\\d+");

    public BetterMapWaypointAddCommand() {
        super("add", "Add a waypoint at your current location");
        this.addAliases(new String[]{"create"});
        this.setPermissionGroup(GameMode.Adventure);
        this.setPermissionGroup(GameMode.Creative);
    }

    protected void execute(@Nonnull CommandContext context, @Nonnull Store<EntityStore> store, @Nonnull Ref<EntityStore> ref, @Nonnull PlayerRef playerRef, @Nonnull World world) {
        Object icon;
        String colorInput;
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player == null) {
            context.sendMessage(Message.raw((String)"Could not find player component"));
            return;
        }
        TransformComponent transformComponent = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
        if (transformComponent == null) {
            context.sendMessage(Message.raw((String)"Could not find transform component"));
            return;
        }
        String name = (String)this.nameArg.get(context);
        if (name == null || name.isEmpty()) {
            name = this.generateAutoName(player.getPlayerConfigData().getPerWorldData(world.getName()));
        }
        if ((colorInput = (String)this.colorArg.get(context)) == null || colorInput.isEmpty()) {
            icon = "Coordinate.png";
        } else {
            String normalized = colorInput.trim().toLowerCase();
            String capitalized = Character.toUpperCase(normalized.charAt(0)) + normalized.substring(1);
            icon = capitalized + "Marker.png";
        }
        Transform transform = PositionUtil.toTransformPacket((com.hypixel.hytale.math.vector.Transform)new com.hypixel.hytale.math.vector.Transform(transformComponent.getPosition()));
        boolean makeGlobal = Boolean.TRUE.equals(this.globalArg.get(context));
        if (makeGlobal && !PermissionsUtil.canUseGlobalWaypoints(player)) {
            context.sendMessage(Message.raw((String)"You don't have permission to create global waypoints. Creating a personal waypoint instead."));
            makeGlobal = false;
        }
        WaypointManager.addWaypoint(player, name, (String)icon, transform, makeGlobal);
        String scope = makeGlobal ? "global" : "personal";
        context.sendMessage(Message.raw((String)("Added " + scope + " waypoint '" + name + "' at your location!")));
    }

    private String generateAutoName(@Nonnull PlayerWorldData perWorldData) {
        MapMarker[] markers = perWorldData.getWorldMapMarkers();
        int max = 0;
        if (markers != null) {
            for (MapMarker m : markers) {
                Matcher matcher;
                if (m == null || m.name == null || !(matcher = AUTO_NAME_PATTERN.matcher(m.name.trim())).matches()) continue;
                try {
                    int n = Integer.parseInt(m.name.substring("Waypoint_".length()));
                    if (n <= max) continue;
                    max = n;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return "Waypoint_" + (max + 1);
    }
}

