/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced.commands;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import dev.ninesliced.commands.BetterMapWaypointCommand;
import dev.ninesliced.commands.PlayerLocationCommand;
import dev.ninesliced.commands.PlayerMaxScaleCommand;
import dev.ninesliced.commands.PlayerMinScaleCommand;
import dev.ninesliced.commands.ReloadCommand;
import dev.ninesliced.commands.config.ConfigCommand;
import dev.ninesliced.configs.BetterMapConfig;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BetterMapCommand
extends AbstractCommand {
    private static final Logger LOGGER = Logger.getLogger(BetterMapCommand.class.getName());

    public BetterMapCommand() {
        super("bettermap", "Manage BetterMap plugin");
        this.addAliases(new String[]{"bm", "map"});
        this.addSubCommand((AbstractCommand)new ConfigCommand());
        this.addSubCommand(new ReloadCommand());
        this.addSubCommand(new PlayerMinScaleCommand());
        this.addSubCommand(new PlayerMaxScaleCommand());
        this.addSubCommand(new PlayerLocationCommand());
        this.addSubCommand((AbstractCommand)new BetterMapWaypointCommand());
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    protected String generatePermissionNode() {
        return "";
    }

    @Nullable
    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        BetterMapConfig config = BetterMapConfig.getInstance();
        context.sendMessage(Message.raw((String)"=== BetterMap Settings ===").color(Color.ORANGE));
        context.sendMessage(Message.raw((String)"Exploration Radius: ").color(Color.YELLOW).insert(Message.raw((String)String.valueOf(config.getExplorationRadius())).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Min Scale: ").color(Color.YELLOW).insert(Message.raw((String)String.valueOf(config.getMinScale())).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Max Scale: ").color(Color.YELLOW).insert(Message.raw((String)String.valueOf(config.getMaxScale())).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Max Chunks: ").color(Color.YELLOW).insert(Message.raw((String)String.valueOf(config.getMaxChunksToLoad())).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Map Quality: ").color(Color.YELLOW).insert(Message.raw((String)config.getMapQuality().name()).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Debug Mode: ").color(Color.YELLOW).insert(Message.raw((String)String.valueOf(config.isDebug())).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Player Radar: ").color(Color.YELLOW).insert(Message.raw((String)(config.isRadarEnabled() ? "Enabled" : "Disabled")).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Hide Players: ").color(Color.YELLOW).insert(Message.raw((String)(config.isHidePlayersOnMap() ? "Enabled" : "Disabled")).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Hide Other Warps: ").color(Color.YELLOW).insert(Message.raw((String)(config.isHideOtherWarpsOnMap() ? "Enabled" : "Disabled")).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Hide Unexplored Warps: ").color(Color.YELLOW).insert(Message.raw((String)(config.isHideUnexploredWarpsOnMap() ? "Enabled" : "Disabled")).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Waypoint Teleport: ").color(Color.YELLOW).insert(Message.raw((String)(config.isAllowWaypointTeleports() ? "Enabled" : "Disabled")).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Marker Teleport: ").color(Color.YELLOW).insert(Message.raw((String)(config.isAllowMapMarkerTeleports() ? "Enabled" : "Disabled")).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Hide All POIs: ").color(Color.YELLOW).insert(Message.raw((String)(config.isHideAllPoiOnMap() ? "Enabled" : "Disabled")).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"Hide Unexplored POIs: ").color(Color.YELLOW).insert(Message.raw((String)(config.isHideUnexploredPoiOnMap() ? "Enabled" : "Disabled")).color(Color.WHITE)));
        String radarRange = config.getRadarRange() == -1 ? "Infinite" : config.getRadarRange() + " blocks";
        context.sendMessage(Message.raw((String)"Radar Range: ").color(Color.YELLOW).insert(Message.raw((String)radarRange).color(Color.WHITE)));
        context.sendMessage(Message.raw((String)"NOTE: The server must be restarted for map quality/max chunks changes to take effect."));
        return CompletableFuture.completedFuture(null);
    }
}

