/*
 * Decompiled with CFR 0.152.
 */
package dev.ninesliced;

import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.component.system.ISystem;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.event.events.player.AddPlayerToWorldEvent;
import com.hypixel.hytale.server.core.event.events.player.DrainPlayerFromWorldEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerDisconnectEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerReadyEvent;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.ninesliced.commands.BetterMapCommand;
import dev.ninesliced.components.ExplorationComponent;
import dev.ninesliced.configs.BetterMapConfig;
import dev.ninesliced.exploration.ExplorationPlayerSetupSystem;
import dev.ninesliced.exploration.ExplorationTicker;
import dev.ninesliced.listeners.ExplorationEventListener;
import dev.ninesliced.managers.ExplorationManager;
import dev.ninesliced.managers.MapPrivacyManager;
import dev.ninesliced.managers.PlayerConfigManager;
import dev.ninesliced.managers.PlayerRadarManager;
import dev.ninesliced.managers.PoiPrivacyManager;
import dev.ninesliced.managers.WarpPrivacyManager;
import dev.ninesliced.managers.WaypointManager;
import dev.ninesliced.providers.LocationHudProvider;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class BetterMap
extends JavaPlugin {
    private static final Logger LOGGER = Logger.getLogger(BetterMap.class.getName());
    private static BetterMap instance;
    private ComponentType<EntityStore, ExplorationComponent> explorationComponentType;
    private LocationHudProvider locationHudProvider;

    public BetterMap(@Nonnull JavaPluginInit init) {
        super(init);
    }

    public static BetterMap get() {
        return instance;
    }

    public LocationHudProvider getLocationHudProvider() {
        return this.locationHudProvider;
    }

    public ComponentType<EntityStore, ExplorationComponent> getExplorationComponentType() {
        return this.explorationComponentType;
    }

    protected void setup() {
        instance = this;
        LOGGER.info("========================================");
        LOGGER.info("Setting up Persistent Map Exploration Mod");
        LOGGER.info("========================================");
        try {
            this.explorationComponentType = this.getEntityStoreRegistry().registerComponent(ExplorationComponent.class, "ExplorationData", ExplorationComponent.CODEC);
            LOGGER.info("Exploration Component: REGISTERED");
            this.getEntityStoreRegistry().registerSystem((ISystem)new ExplorationPlayerSetupSystem());
            LOGGER.info("Exploration Setup System: REGISTERED");
            Path serverRoot = Paths.get(".", new String[0]).toAbsolutePath().normalize();
            BetterMapConfig.getInstance().initialize(serverRoot);
            PlayerConfigManager.initialize(serverRoot.resolve("mods").resolve("BetterMap"));
            LOGGER.info("Player Config Manager: INITIALIZED");
            MapPrivacyManager.getInstance().initialize();
            LOGGER.info("MapPrivacyManager: INITIALIZED");
            WarpPrivacyManager.getInstance().initialize();
            LOGGER.info("WarpPrivacyManager: INITIALIZED");
            PoiPrivacyManager.getInstance().initialize();
            LOGGER.info("PoiPrivacyManager: INITIALIZED");
            Path configDir = BetterMapConfig.getInstance().getConfigDirectory();
            if (configDir == null) {
                configDir = serverRoot.resolve("mods").resolve("BetterMap");
            }
            WaypointManager.initialize(configDir);
            LOGGER.info("Waypoint Persistence: INITIALIZED");
            ExplorationManager.config().updateRate(0.5f).enablePersistence("exploration_data").build();
            LOGGER.info("Exploration Manager: INITIALIZED");
            ExplorationTicker.getInstance().start();
            LOGGER.info("Exploration Ticker: STARTED");
            this.getCommandRegistry().registerCommand((AbstractCommand)new BetterMapCommand());
            LOGGER.info("Mod Command: REGISTERED");
            PlayerRadarManager.getInstance();
            LOGGER.info("Player Radar: INITIALIZED");
            this.getEventRegistry().registerGlobal(PlayerReadyEvent.class, ExplorationEventListener::onPlayerReady);
            this.getEventRegistry().registerGlobal(PlayerDisconnectEvent.class, ExplorationEventListener::onPlayerQuit);
            this.getEventRegistry().registerGlobal(AddPlayerToWorldEvent.class, ExplorationEventListener::onPlayerJoinWorld);
            this.getEventRegistry().registerGlobal(DrainPlayerFromWorldEvent.class, ExplorationEventListener::onPlayerLeaveWorld);
            LOGGER.info("Exploration Events: REGISTERED");
            LOGGER.info("========================================");
            LOGGER.info("Plugin Setup Complete!");
            LOGGER.info("Players will now have persistent");
            LOGGER.info("exploration tracking on the world map");
            LOGGER.info("========================================");
        }
        catch (Exception e) {
            LOGGER.severe("Failed to setup Exploration Plugin: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("Plugin initialization failed", e);
        }
    }

    protected void shutdown() {
        if (this.locationHudProvider != null) {
            this.locationHudProvider.cleanup();
        }
        PlayerRadarManager.getInstance().cleanup();
        super.shutdown();
    }
}

