/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.advancediteminfo;

import com.buuz135.advancediteminfo.AdvancedItemInfoGui;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.server.core.command.commands.player.inventory.InventorySeeCommand;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.ParseResult;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.arguments.types.SingleArgumentType;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class OpenAdvancedInfoCommand
extends AbstractCommand {
    private final OptionalArg<String> argument;

    protected OpenAdvancedInfoCommand() {
        super("advancedinfo", "Displays all the items in the game and shows all the info from them", false);
        this.addAliases(new String[]{"aii", "iteminfo"});
        SingleArgumentType<String> arg = new SingleArgumentType<String>(this, "Default Search", "Opens the screen with this text in the search field", new String[]{"iron", "stone"}){
            {
                Objects.requireNonNull(this$0);
                super(arg0, arg1, arg2);
            }

            @NullableDecl
            public String parse(String s, ParseResult parseResult) {
                return s;
            }
        };
        this.argument = this.withOptionalArg("s", "Searches items that have this name", (ArgumentType)arg);
        this.setPermissionGroup(GameMode.Adventure);
    }

    @Nullable
    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        CommandSender sender = context.sender();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Ref ref = player.getReference();
            if (ref != null && ref.isValid()) {
                Store store = ref.getStore();
                World world = ((EntityStore)store.getExternalData()).getWorld();
                return CompletableFuture.runAsync(() -> {
                    PlayerRef playerRefComponent = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
                    String defaultSearch = "";
                    if (context.get(this.argument) != null) {
                        defaultSearch = (String)context.get(this.argument);
                    }
                    if (playerRefComponent != null) {
                        player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new AdvancedItemInfoGui(playerRefComponent, CustomPageLifetime.CanDismiss, defaultSearch));
                    }
                }, (Executor)world);
            }
            context.sendMessage(InventorySeeCommand.MESSAGE_COMMANDS_ERRORS_PLAYER_NOT_IN_WORLD);
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

