/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.advancediteminfo;

import com.buuz135.advancediteminfo.OpenAdvancedInfoCommand;
import com.hypixel.hytale.assetstore.event.LoadedAssetsEvent;
import com.hypixel.hytale.assetstore.event.RemovedAssetsEvent;
import com.hypixel.hytale.assetstore.map.DefaultAssetMap;
import com.hypixel.hytale.protocol.BenchRequirement;
import com.hypixel.hytale.server.core.asset.type.item.config.CraftingRecipe;
import com.hypixel.hytale.server.core.asset.type.item.config.Item;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.inventory.MaterialQuantity;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class Main
extends JavaPlugin {
    public static Map<String, Item> ITEMS = new HashMap<String, Item>();
    public static final Map<String, Map<String, BenchRequirement[]>> recipeRegistries = new Object2ObjectOpenHashMap();

    public Main(@Nonnull JavaPluginInit init) {
        super(init);
    }

    protected void setup() {
        super.setup();
        this.getCommandRegistry().registerCommand((AbstractCommand)new OpenAdvancedInfoCommand());
        this.getEventRegistry().register(LoadedAssetsEvent.class, Item.class, Main::onItemAssetLoad);
        this.getEventRegistry().register(LoadedAssetsEvent.class, CraftingRecipe.class, Main::onRecipeLoad);
        this.getEventRegistry().register(RemovedAssetsEvent.class, CraftingRecipe.class, Main::onRecipeRemove);
    }

    private static void onItemAssetLoad(LoadedAssetsEvent<String, Item, DefaultAssetMap<String, Item>> event) {
        ITEMS = ((DefaultAssetMap)event.getAssetMap()).getAssetMap();
    }

    private static void onRecipeLoad(LoadedAssetsEvent<String, CraftingRecipe, DefaultAssetMap<String, CraftingRecipe>> event) {
        for (CraftingRecipe recipe : event.getLoadedAssets().values()) {
            for (MaterialQuantity output : recipe.getOutputs()) {
                if (!recipeRegistries.containsKey(output.getItemId())) continue;
                recipeRegistries.get(output.getItemId()).remove(recipe.getId());
            }
            if (recipe.getBenchRequirement() == null) continue;
            for (MaterialQuantity output : recipe.getOutputs()) {
                if (!recipeRegistries.containsKey(output.getItemId())) {
                    recipeRegistries.put(output.getItemId(), new HashMap());
                }
                recipeRegistries.get(output.getItemId()).put(recipe.getId(), recipe.getBenchRequirement());
            }
        }
    }

    private static void onRecipeRemove(RemovedAssetsEvent<String, CraftingRecipe, DefaultAssetMap<String, CraftingRecipe>> event) {
        for (String key : recipeRegistries.keySet()) {
            for (String removedAsset : event.getRemovedAssets()) {
                recipeRegistries.get(key).remove(removedAsset);
            }
        }
    }
}

