/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.advancediteminfo;

import com.buuz135.advancediteminfo.Main;
import com.buuz135.advancediteminfo.MessageHelper;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.BenchRequirement;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.asset.type.item.config.Item;
import com.hypixel.hytale.server.core.command.system.MatchResult;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.modules.i18n.I18nModule;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Color;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public class AdvancedItemInfoGui
extends InteractiveCustomUIPage<SearchGuiData> {
    private String searchQuery = "";
    private final Map<String, Item> visibleItems = new HashMap<String, Item>();

    public AdvancedItemInfoGui(@Nonnull PlayerRef playerRef, @Nonnull CustomPageLifetime lifetime, String defaultSearchQuery) {
        super(playerRef, lifetime, SearchGuiData.CODEC);
        this.searchQuery = defaultSearchQuery;
    }

    public void build(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder uiCommandBuilder, @Nonnull UIEventBuilder uiEventBuilder, @Nonnull Store<EntityStore> store) {
        uiCommandBuilder.append("Pages/Buuz135_AdvancedItemInfo_Gui.ui");
        uiCommandBuilder.set("#SearchInput.Value", this.searchQuery);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#SearchInput", EventData.of((String)"@SearchQuery", (String)"#SearchInput.Value"), false);
        this.buildList(ref, uiCommandBuilder, uiEventBuilder, (ComponentAccessor<EntityStore>)store);
    }

    public void handleDataEvent(@Nonnull Ref<EntityStore> ref, @Nonnull Store<EntityStore> store, @Nonnull SearchGuiData data) {
        super.handleDataEvent(ref, store, (Object)data);
        if (data.item != null) {
            this.sendUpdate();
        }
        if (data.searchQuery != null) {
            this.searchQuery = data.searchQuery.trim().toLowerCase();
            UICommandBuilder commandBuilder = new UICommandBuilder();
            UIEventBuilder eventBuilder = new UIEventBuilder();
            this.buildList(ref, commandBuilder, eventBuilder, (ComponentAccessor<EntityStore>)store);
            this.sendUpdate(commandBuilder, eventBuilder, false);
        }
    }

    private void buildList(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder commandBuilder, @Nonnull UIEventBuilder eventBuilder, @Nonnull ComponentAccessor<EntityStore> componentAccessor) {
        HashMap<String, Item> itemList = new HashMap<String, Item>(Main.ITEMS);
        Player playerComponent = (Player)componentAccessor.getComponent(ref, Player.getComponentType());
        assert (playerComponent != null);
        if (this.searchQuery.isEmpty()) {
            this.visibleItems.clear();
            this.visibleItems.putAll(itemList);
        } else {
            ObjectArrayList results = new ObjectArrayList();
            for (Map.Entry<String, Item> entry : itemList.entrySet()) {
                if (entry.getValue() == null) continue;
                results.add((Object)new SearchResult(entry.getKey(), MatchResult.EXACT));
            }
            String[] terms = this.searchQuery.split(" ");
            for (int termIndex = 0; termIndex < terms.length; ++termIndex) {
                String term = terms[termIndex].toLowerCase(Locale.ENGLISH);
                for (int cmdIndex = results.size() - 1; cmdIndex >= 0; --cmdIndex) {
                    SearchResult result = (SearchResult)results.get(cmdIndex);
                    Item item = itemList.get(result.name);
                    MatchResult match = MatchResult.NONE;
                    if (item != null) {
                        String message = I18nModule.get().getMessage(this.playerRef.getLanguage(), item.getTranslationKey());
                        MatchResult matchResult = match = message != null && message.toLowerCase(Locale.ENGLISH).contains(term) ? MatchResult.EXACT : MatchResult.NONE;
                    }
                    if (match == MatchResult.NONE) {
                        results.remove(cmdIndex);
                        continue;
                    }
                    result.match = result.match.min(match);
                }
            }
            results.sort(SearchResult.COMPARATOR);
            this.visibleItems.clear();
            for (SearchResult result : results) {
                this.visibleItems.put(result.name, itemList.get(result.name));
            }
        }
        this.buildButtons(this.visibleItems, playerComponent, commandBuilder, eventBuilder);
    }

    private void buildButtons(Map<String, Item> items, @Nonnull Player playerComponent, @Nonnull UICommandBuilder commandBuilder, @Nonnull UIEventBuilder eventBuilder) {
        commandBuilder.clear("#SubcommandCards");
        commandBuilder.set("#SubcommandSection.Visible", true);
        int rowIndex = 0;
        int cardsInCurrentRow = 0;
        for (Map.Entry<String, Item> entry : items.entrySet()) {
            Item item = entry.getValue();
            if (cardsInCurrentRow == 0) {
                commandBuilder.appendInline("#SubcommandCards", "Group { LayoutMode: Left; Anchor: (Bottom: 0); }");
            }
            commandBuilder.append("#SubcommandCards[" + rowIndex + "]", "Pages/Buuz135_AdvancedItemInfo_SearchItemIcon.ui");
            MessageHelper.ML tooltip = MessageHelper.multiLine();
            tooltip.append(Message.translation((String)item.getTranslationKey()).bold(true)).nl();
            tooltip.separator();
            tooltip = this.addTooltipLine(tooltip, "ID: ", entry.getKey());
            tooltip = this.addTooltipLine(tooltip, "Icon: ", item.getIcon());
            tooltip = this.addTooltipLine(tooltip, "Quality: ", item.getQualityIndex());
            tooltip = this.addTooltipLine(tooltip, "Item Level: ", item.getItemLevel());
            tooltip = this.addTooltipLine(tooltip, "Max Stack: ", item.getMaxStack());
            tooltip = this.addTooltipLine(tooltip, "Max Durability: ", item.getMaxDurability());
            tooltip = this.addTooltipLine(tooltip, "Is Consumable: ", this.formatBoolean(item.isConsumable()));
            tooltip = this.addTooltipLine(tooltip, "Has Block: ", this.formatBoolean(item.hasBlockType()));
            tooltip = this.addTooltipLine(tooltip, "Fuel Quality: ", item.getFuelQuality());
            tooltip = tooltip.separator();
            tooltip = this.addTooltipLine(tooltip, "Is Tool: ", this.formatBoolean(item.getTool() != null));
            tooltip = this.addTooltipLine(tooltip, "Is Weapon: ", this.formatBoolean(item.getWeapon() != null));
            tooltip = this.addTooltipLine(tooltip, "Is Armor: ", this.formatBoolean(item.getArmor() != null));
            tooltip = this.addTooltipLine(tooltip, "Is Glider: ", this.formatBoolean(item.getGlider() != null));
            tooltip = this.addTooltipLine(tooltip, "Is Utility: ", this.formatBoolean(item.getUtility() != null));
            tooltip = this.addTooltipLine(tooltip, "Is Portal Key: ", this.formatBoolean(item.getPortalKey() != null));
            if (Main.recipeRegistries.containsKey(entry.getKey())) {
                tooltip = tooltip.separator();
                tooltip = this.addTooltipLine(tooltip, "Can Be Made In:", "");
                ArrayList<CallSite> addedRecipes = new ArrayList<CallSite>();
                for (BenchRequirement[] value : Main.recipeRegistries.get(entry.getKey()).values()) {
                    for (BenchRequirement benchRequirement : value) {
                        String customId = benchRequirement.id + benchRequirement.requiredTierLevel;
                        if (addedRecipes.contains(customId)) continue;
                        tooltip = this.addTooltipLine(tooltip, " - ", this.formatBench(benchRequirement.id) + " Tier " + benchRequirement.requiredTierLevel);
                        addedRecipes.add((CallSite)((Object)customId));
                    }
                }
            }
            commandBuilder.set("#SubcommandCards[" + rowIndex + "][" + cardsInCurrentRow + "].TooltipTextSpans", tooltip.build());
            commandBuilder.set("#SubcommandCards[" + rowIndex + "][" + cardsInCurrentRow + "] #ItemIcon.ItemId", entry.getKey());
            commandBuilder.set("#SubcommandCards[" + rowIndex + "][" + cardsInCurrentRow + "] #ItemName.TextSpans", Message.translation((String)item.getTranslationKey()));
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#SubcommandCards[" + rowIndex + "][" + cardsInCurrentRow + "]", EventData.of((String)"Item", (String)entry.getKey()));
            if (++cardsInCurrentRow < 7) continue;
            cardsInCurrentRow = 0;
            ++rowIndex;
        }
    }

    private MessageHelper.ML addTooltipLine(MessageHelper.ML tooltip, String key, int value) {
        return this.addTooltipLine(tooltip, key, "" + value);
    }

    private MessageHelper.ML addTooltipLine(MessageHelper.ML tooltip, String key, double value) {
        return this.addTooltipLine(tooltip, key, "" + value);
    }

    private MessageHelper.ML addTooltipLine(MessageHelper.ML tooltip, String key, String value) {
        return tooltip.append(Message.raw((String)key).color("#93844c").bold(true)).append(Message.raw((String)value)).nl();
    }

    private MessageHelper.ML addTooltipLine(MessageHelper.ML tooltip, String key, Message value) {
        return tooltip.append(Message.raw((String)key).color("#93844c").bold(true)).append(value).nl();
    }

    private Message formatBoolean(boolean value) {
        return value ? Message.raw((String)"Yes").color(Color.GREEN) : Message.raw((String)"No").color(Color.RED);
    }

    private String formatBench(String name) {
        if (!((String)(name = ((String)name).replaceAll("_", " "))).contains("Bench")) {
            name = (String)name + " Bench";
        }
        return name;
    }

    public static class SearchGuiData {
        static final String KEY_ITEM = "Item";
        static final String KEY_SEARCH_QUERY = "@SearchQuery";
        public static final BuilderCodec<SearchGuiData> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(SearchGuiData.class, SearchGuiData::new).addField(new KeyedCodec("@SearchQuery", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.searchQuery = s;
        }, searchGuiData -> searchGuiData.searchQuery)).addField(new KeyedCodec("Item", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.item = s;
        }, searchGuiData -> searchGuiData.item)).build();
        private String item;
        private String searchQuery;
    }

    private static class SearchResult {
        public static final Comparator<SearchResult> COMPARATOR = Comparator.comparing(o -> o.match);
        private final String name;
        private MatchResult match;

        public SearchResult(String name, MatchResult match) {
            this.name = name;
            this.match = match;
        }
    }
}

