/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.util.Arrays;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.client.SocketHelper;
import org.mariadb.jdbc.client.socket.impl.SocketHandlerFunction;
import org.mariadb.jdbc.client.socket.impl.SocketUtility;
import org.mariadb.jdbc.export.SslMode;
import org.mariadb.jdbc.plugin.Credential;
import org.mariadb.jdbc.plugin.CredentialPlugin;
import org.mariadb.jdbc.util.ConfigurableSocketFactory;

public final class ConnectionHelper {
    private static final SocketHandlerFunction socketHandler;

    public static Socket createSocket(Configuration conf, HostAddress hostAddress) throws IOException, SQLException {
        return socketHandler.apply(conf, hostAddress);
    }

    public static Socket standardSocket(Configuration conf, HostAddress hostAddress) throws IOException, SQLException {
        String socketFactoryName = conf.socketFactory();
        if (socketFactoryName != null) {
            try {
                Class<?> socketFactoryClass = Class.forName(socketFactoryName, false, ConnectionHelper.class.getClassLoader());
                if (!SocketFactory.class.isAssignableFrom(socketFactoryClass)) {
                    throw new IOException("Wrong Socket factory implementation '" + conf.socketFactory() + "'");
                }
                Constructor<?> constructor = socketFactoryClass.getConstructor(new Class[0]);
                SocketFactory socketFactory = (SocketFactory)constructor.newInstance(new Object[0]);
                if (socketFactory instanceof ConfigurableSocketFactory) {
                    ((ConfigurableSocketFactory)socketFactory).setConfiguration(conf, hostAddress.host);
                }
                return socketFactory.createSocket();
            }
            catch (Exception exp) {
                throw new IOException("Socket factory failed to initialized with option \"socketFactory\" set to \"" + conf.socketFactory() + "\"", exp);
            }
        }
        SocketFactory socketFactory = SocketFactory.getDefault();
        return socketFactory.createSocket();
    }

    public static Socket connectSocket(Configuration conf, HostAddress hostAddress) throws SQLException {
        try {
            Socket socket = ConnectionHelper.createSocket(conf, hostAddress);
            SocketHelper.setSocketOption(conf, socket);
            if (!socket.isConnected()) {
                InetSocketAddress sockAddr = hostAddress.pipe == null && hostAddress.localSocket == null ? new InetSocketAddress(hostAddress.host, hostAddress.port) : null;
                socket.connect(sockAddr, conf.connectTimeout());
            }
            return socket;
        }
        catch (SocketTimeoutException ste) {
            throw new SQLTimeoutException(String.format("Socket timeout when connecting to %s. %s", hostAddress, ste.getMessage()), "08000", ste);
        }
        catch (IOException ioe) {
            throw new SQLNonTransientConnectionException(String.format("Socket fail to connect to %s. %s", hostAddress, ioe.getMessage()), "08000", ioe);
        }
    }

    public static long initializeClientCapabilities(Configuration configuration, long serverCapabilities, HostAddress hostAddress) {
        long capabilities = ConnectionHelper.initializeBaseCapabilities();
        capabilities = ConnectionHelper.applyOptionalCapabilities(capabilities, configuration);
        capabilities = ConnectionHelper.applyTechnicalCapabilities(capabilities, configuration);
        capabilities = ConnectionHelper.applyConnectionCapabilities(capabilities, configuration, hostAddress);
        return capabilities & serverCapabilities;
    }

    private static long initializeBaseCapabilities() {
        return 12493568L;
    }

    private static long applyOptionalCapabilities(long capabilities, Configuration configuration) {
        if (ConnectionHelper.getBooleanProperty(configuration, "enableBulkUnitResult", true)) {
            capabilities |= 0x2000000000L;
        }
        if (ConnectionHelper.getBooleanProperty(configuration, "disableSessionTracking", false)) {
            capabilities &= 0xFFFFFFFFFF7FFFFFL;
        }
        if (ConnectionHelper.shouldEnableMetadataCache(configuration)) {
            capabilities |= 0x1000000000L;
        }
        if (ConnectionHelper.getBooleanProperty(configuration, "interactiveClient", false)) {
            capabilities |= 0x400L;
        }
        if (configuration.useBulkStmts() || configuration.useBulkStmtsForInserts()) {
            capabilities |= 0x400000000L;
        }
        if (!configuration.useAffectedRows()) {
            capabilities |= 2L;
        }
        if (configuration.allowMultiQueries() || configuration.rewriteBatchedStatements()) {
            capabilities |= 0x10000L;
        }
        if (configuration.allowLocalInfile()) {
            capabilities |= 0x80L;
        }
        return capabilities;
    }

    private static long applyTechnicalCapabilities(long capabilities, Configuration configuration) {
        if (ConnectionHelper.getBooleanProperty(configuration, "extendedTypeInfo", true)) {
            capabilities |= 0x800000000L;
        }
        if (ConnectionHelper.getBooleanProperty(configuration, "deprecateEof", true)) {
            capabilities |= 0x1000000L;
        }
        if (configuration.useCompression()) {
            capabilities |= 0x20L;
        }
        return capabilities;
    }

    private static long applyConnectionCapabilities(long capabilities, Configuration configuration, HostAddress hostAddress) {
        if (ConnectionHelper.shouldConnectWithDb(configuration, hostAddress)) {
            capabilities |= 8L;
        }
        if (ConnectionHelper.shouldEnableSsl(configuration, hostAddress)) {
            capabilities |= 0x800L;
        }
        if (!configuration.disconnectOnExpiredPasswords()) {
            capabilities |= 0x400000L;
        }
        return capabilities;
    }

    private static boolean getBooleanProperty(Configuration configuration, String propertyName, boolean defaultValue) {
        return Boolean.parseBoolean(configuration.nonMappedOptions().getProperty(propertyName, String.valueOf(defaultValue)));
    }

    private static boolean shouldEnableMetadataCache(Configuration configuration) {
        return configuration.useServerPrepStmts() && ConnectionHelper.getBooleanProperty(configuration, "enableSkipMeta", true);
    }

    private static boolean shouldConnectWithDb(Configuration configuration, HostAddress hostAddress) {
        return configuration.database() != null && (!configuration.createDatabaseIfNotExist() || configuration.createDatabaseIfNotExist() && hostAddress != null && hostAddress.primary == false);
    }

    private static boolean shouldEnableSsl(Configuration configuration, HostAddress hostAddress) {
        SslMode sslMode = hostAddress.sslMode == null ? configuration.sslMode() : hostAddress.sslMode;
        return sslMode != SslMode.DISABLE;
    }

    public static Credential loadCredential(CredentialPlugin credentialPlugin, Configuration configuration, HostAddress hostAddress) throws SQLException {
        if (credentialPlugin != null) {
            return (Credential)credentialPlugin.initialize(configuration, configuration.user(), hostAddress).get();
        }
        return new Credential(configuration.user(), configuration.password());
    }

    static void enabledSslProtocolSuites(SSLSocket sslSocket, Configuration conf) throws SQLException {
        if (conf.enabledSslProtocolSuites() != null) {
            String[] protocols;
            List<String> possibleProtocols = Arrays.asList(sslSocket.getSupportedProtocols());
            for (String protocol : protocols = conf.enabledSslProtocolSuites().split("[,;\\s]+")) {
                if (possibleProtocols.contains(protocol)) continue;
                throw new SQLException("Unsupported SSL protocol '" + protocol + "'. Supported protocols : " + possibleProtocols.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledProtocols(protocols);
        }
    }

    static void enabledSslCipherSuites(SSLSocket sslSocket, Configuration conf) throws SQLException {
        if (conf.enabledSslCipherSuites() != null) {
            String[] ciphers;
            List<String> possibleCiphers = Arrays.asList(sslSocket.getSupportedCipherSuites());
            for (String cipher : ciphers = conf.enabledSslCipherSuites().split("[,;\\s]+")) {
                if (possibleCiphers.contains(cipher)) continue;
                throw new SQLException("Unsupported SSL cipher '" + cipher + "'. Supported ciphers : " + possibleCiphers.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledCipherSuites(ciphers);
        }
    }

    static {
        SocketHandlerFunction init;
        try {
            init = SocketUtility.getSocketHandler();
        }
        catch (Throwable t2) {
            init = ConnectionHelper::standardSocket;
        }
        socketHandler = init;
    }
}

