/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.utils;

import com.azuredoom.levelingcore.config.GUIConfig;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatMap;
import com.hypixel.hytale.server.core.modules.entitystats.asset.DefaultEntityStatTypes;
import com.hypixel.hytale.server.core.modules.entitystats.modifier.Modifier;
import com.hypixel.hytale.server.core.modules.entitystats.modifier.StaticModifier;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.util.Config;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class StatsUtils {
    private StatsUtils() {
    }

    @NullableDecl
    private static World getWorld(Player player) {
        if (player == null) {
            return null;
        }
        return player.getWorld();
    }

    @NullableDecl
    private static EntityStatMap getStatMap(Player player, PlayerRef playerRef) {
        return (EntityStatMap)player.getReference().getStore().getComponent(player.getReference(), EntityStatMap.getComponentType());
    }

    public static void doHealthIncrease(Player player, PlayerRef playerRef, float healthMultiplier) {
        EntityStatMap playerStatMap = StatsUtils.getStatMap(player, playerRef);
        if (playerStatMap == null) {
            return;
        }
        int healthIndex = DefaultEntityStatTypes.getHealth();
        StaticModifier modifier = new StaticModifier(Modifier.ModifierTarget.MAX, StaticModifier.CalculationType.ADDITIVE, healthMultiplier);
        String modifierKey = "LevelingCore_health";
        playerStatMap.putModifier(healthIndex, modifierKey, (Modifier)modifier);
    }

    public static void doStaminaIncrease(Player player, PlayerRef playerRef, float staminaMultiplier) {
        EntityStatMap playerStatMap = StatsUtils.getStatMap(player, playerRef);
        if (playerStatMap == null) {
            return;
        }
        int staminaIndex = DefaultEntityStatTypes.getStamina();
        StaticModifier modifier = new StaticModifier(Modifier.ModifierTarget.MAX, StaticModifier.CalculationType.ADDITIVE, staminaMultiplier);
        String modifierKey = "LevelingCore_stamina";
        playerStatMap.putModifier(staminaIndex, modifierKey, (Modifier)modifier);
    }

    public static void doManaIncrease(Player player, PlayerRef playerRef, float manaMultiplier) {
        EntityStatMap playerStatMap = StatsUtils.getStatMap(player, playerRef);
        if (playerStatMap == null) {
            return;
        }
        int manaIndex = DefaultEntityStatTypes.getMana();
        StaticModifier modifier = new StaticModifier(Modifier.ModifierTarget.MAX, StaticModifier.CalculationType.ADDITIVE, manaMultiplier);
        String modifierKey = "LevelingCore_mana";
        playerStatMap.putModifier(manaIndex, modifierKey, (Modifier)modifier);
    }

    public static void resetStats(Player player, PlayerRef playerRef) {
        EntityStatMap playerStatMap = StatsUtils.getStatMap(player, playerRef);
        if (playerStatMap == null) {
            return;
        }
        int healthIndex = DefaultEntityStatTypes.getHealth();
        int staminaIndex = DefaultEntityStatTypes.getStamina();
        int manaIndex = DefaultEntityStatTypes.getMana();
        playerStatMap.resetStatValue(healthIndex);
        playerStatMap.resetStatValue(staminaIndex);
        playerStatMap.resetStatValue(manaIndex);
    }

    public static void applyAllStats(Player player, PlayerRef playerRef, int newLevel, Config<GUIConfig> config) {
        StatsUtils.doHealthIncrease(player, playerRef, (float)newLevel * ((GUIConfig)config.get()).getHealthLevelUpMultiplier());
        StatsUtils.doStaminaIncrease(player, playerRef, (float)newLevel * ((GUIConfig)config.get()).getStaminaLevelUpMultiplier());
        StatsUtils.doManaIncrease(player, playerRef, (float)newLevel * ((GUIConfig)config.get()).getManaLevelUpMultiplier());
        if (((GUIConfig)config.get()).isEnableStatHealing()) {
            StatsUtils.healMaxStat(player, playerRef, config);
        }
    }

    private static void healMaxStat(Player player, PlayerRef playerRef, Config<GUIConfig> config) {
        EntityStatMap playerStatMap = StatsUtils.getStatMap(player, playerRef);
        if (playerStatMap == null) {
            return;
        }
        playerStatMap.maximizeStatValue(EntityStatMap.Predictable.SELF, DefaultEntityStatTypes.getHealth());
        playerStatMap.maximizeStatValue(EntityStatMap.Predictable.SELF, DefaultEntityStatTypes.getStamina());
        playerStatMap.maximizeStatValue(EntityStatMap.Predictable.SELF, DefaultEntityStatTypes.getMana());
    }
}

