/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.utils;

import com.azuredoom.levelingcore.LevelingCore;
import com.azuredoom.levelingcore.level.rewards.LevelRewards;
import com.azuredoom.levelingcore.level.rewards.RewardEntry;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.inventory.container.CombinedItemContainer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class LevelUpRewardsUtil {
    private static final ConcurrentHashMap<UUID, Integer> LAST_REWARDED_LEVEL = new ConcurrentHashMap();

    public static void giveRewards(int newLevel, Player player) {
        Integer last = LAST_REWARDED_LEVEL.getOrDefault(player.getUuid(), 0);
        if (newLevel <= last) {
            return;
        }
        Map<Integer, List<RewardEntry>> rewardsByLevel = LevelRewards.loadOrCreate(LevelingCore.configPath);
        CombinedItemContainer inv = player.getInventory().getCombinedStorageFirst();
        for (int lvl = last + 1; lvl <= newLevel; ++lvl) {
            List<RewardEntry> rewards = rewardsByLevel.get(lvl);
            if (rewards == null || rewards.isEmpty()) continue;
            for (RewardEntry reward : rewards) {
                inv.addItemStack(new ItemStack(reward.itemNameId(), reward.quantity()));
            }
        }
        LAST_REWARDED_LEVEL.put(player.getUuid(), newLevel);
    }

    public static void clear(UUID playerId) {
        LAST_REWARDED_LEVEL.remove(playerId);
    }
}

